package com.apress.springrecipes.court.domain;

import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

import java.util.Calendar;
import java.util.Date;


@Component
public class ReservationValidator implements Validator {
    public boolean supports(Class clazz) {
        return Reservation.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "courtName", "required.courtName", "Nazwa kortu jest wymagana.");
        ValidationUtils.rejectIfEmpty(errors, "date", "required.date", "Data jest wymagana.");
        ValidationUtils.rejectIfEmpty(errors, "hour", "required.hour", "Godzina jest wymagana.");
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "player.name", "required.playerName", "Nazwisko gracza jest wymagane.");
        ValidationUtils.rejectIfEmpty(errors, "sportType", "required.sportType", "Dyscyplina jest wymagana.");

        Reservation reservation = (Reservation) target;
        Date date = reservation.getDate();
        int hour = reservation.getHour();

        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);

            if (calendar.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY) {
                if ((hour < 8) || (hour > 22)) {
                    errors.reject("invalid.holidayHour", "Błędna godzina w dniu wolnym.");
                }
            } else {
                if ((hour < 9) || (hour > 21)) {
                    errors.reject("invalid.weekdayHour", "Błędna godzina w dniu roboczym.");
                }
            }
        }
    }
}
