package com.apress.springrecipes.court.domain;

import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;


@Component
public class PeriodicReservationValidator implements Validator {
    public boolean supports(Class clazz) {
        return PeriodicReservation.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        validateCourt(target, errors);
        validateTime(target, errors);
        validatePlayer(target, errors);
    }

    public void validateCourt(Object target, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "courtName", "required.courtName", "Nazwa kortu jest wymagana.");
    }

    public void validateTime(Object target, Errors errors) {
        ValidationUtils.rejectIfEmpty(errors, "fromDate", "required.fromDate", "Data początkowa jest wymagana.");
        ValidationUtils.rejectIfEmpty(errors, "toDate", "required.toDate", "Data końcowa jest wymagana.");
        ValidationUtils.rejectIfEmpty(errors, "period", "required.period", "Okres jest wymagany.");
        ValidationUtils.rejectIfEmpty(errors, "hour", "required.hour", "Godzina jest wymagana.");
    }

    public void validatePlayer(Object target, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "player.name", "required.playerName", "Nazwisko gracza jest wymagane.");
    }
}
