package com.apress.springrecipes.osgi.helloworld.service;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;


public class GreeterServiceImpl implements GreeterService {
    private Map<String, String> salutation;

    public GreeterServiceImpl() {
        salutation = new HashMap<String, String>();
        salutation.put(Locale.ENGLISH.toString(), "Hello, %s");
        salutation.put(Locale.FRENCH.toString(), "Bonjour, %s");
        salutation.put(Locale.ITALIAN.toString(), "Buongiorno, %s");
    }

    /**
     * @param language Dowolny język, o ile znajduje się na liście <code>Locale.ENGLISH.toString()</code>,
     *                 <code>Locale.ITALIAN.toString()</code>, <code>Locale.FRENCH.toString()</code>. :-)
     * @param name     Imię witanej osoby
     *
     * @return Pozdrowienie w wybranym języku skierowane do osoby o podanym imieniu
     */
    public String greet(String language, String name) {
        if (salutation.containsKey(language)) {
            return String.format(salutation.get(language), name);
        }

        throw new RuntimeException(String.format("Wybrany język (%s) nie istnieje", language));
    }
}
