// Wersja końcowa 
package com.apress.springrecipes.court.web;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.beans.factory.annotation.Value;

@Controller
public class AboutController {


    @Value("#{ messageSource.getMessage('admin.email',null,'en')}")
    private String email;

    // Metoda jest powiązana bezpośrednio z adresem URL /about
    @RequestMapping("/about")
    // Metoda przyjmuje parametr typu Model 
    public String courtReservation(Model model) {
	// Dodawanie adresu e-mail do modelu, aby można wyświetlić ten adres w widoku
        model.addAttribute("email", email);
	// Zwracanie widoku about. Ten widok jest
	// wiązany z plikiem /WEB-INF/jsp/about.jsp
	return "about";
    }
}
