package com.springbook.interceptors;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TestTxInterceptor implements MethodInterceptor {
   private PlatformTransactionManager platformTransactionManager;

   public PlatformTransactionManager getPlatformTransactionManager() {
      return platformTransactionManager;
   }

   public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
      this.platformTransactionManager = platformTransactionManager;
   }

   public Object invoke(MethodInvocation methodInvocation) throws Throwable {
      DefaultTransactionDefinition def = new DefaultTransactionDefinition();  
      def.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRED);
      TransactionStatus status = platformTransactionManager.getTransaction(def);
      Object results = null;
      try {
         results = methodInvocation.proceed();
      } finally {
         platformTransactionManager.rollback(status);
      }
      return results;

   }
}
