
import com.springbook.*;
import com.springbook.exceptions.AddReservationException;
import junit.framework.TestCase;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

import java.util.Date;
import java.util.List;

public class MultiDBFacadeTest extends TestCase {

    private ApplicationContext ctx;
    RentABike store = null;

    public void setUp() throws Exception {
        ctx = new FileSystemXmlApplicationContext("/war/WEB-INF/rentaBikeApp-servlet.xml");
        store = (RentABike)ctx.getBean("RentABike");
    }

    public void testGetBikes() throws Exception {
        List bikes = store.getBikes();
        assertNotNull(bikes);
        assertTrue(bikes.size() > 0);
    }

    public void testGetBike() throws Exception {
        Bike bike = store.getBike(2);
        assertNotNull(bike);
        assertEquals("Cannondale", bike.getManufacturer());
        assertNotNull(bike.getReservations());
        assertTrue(0<bike.getReservations().size());
    }

    public void testAddCustomer() throws Exception {
        Customer c = new Customer(-1, "Roger", "Clemons");
        store.saveCustomer(c);
        store.deleteCustomer(c);
    }

    public void testCustomer() throws Exception {
        Customer c = store.getCustomer(1);
        assertNotNull(c);
        assertEquals("Justin", c.getFirstName());
    }

    public void testAddBike() throws Exception {
        Bike bike = new Bike(-1, "MjProducent", "MjRower", 12, "12312312", 12.00, "Nowy");
        store.saveBike(bike);
        bike = store.getBike("12312312");
        assertNotNull(bike);
        assertEquals("MyMan", bike.getManufacturer());
        store.deleteBike(bike);
        List bikes = store.getBikes();
        assertEquals(3, bikes.size());

    }

    public void testReservation() throws Exception {
        Reservation r = store.getReservation(1);
        assertNotNull(r);
        assertNotNull(r.getBike());
        assertNotNull(r.getCustomer());
    }

    public void testDate() throws Exception {

        List l = store.getReservations(new Date(Date.parse("9/15/2004")));
        assertNotNull(l);
        assertTrue(0<l.size());

    }

    public void testAddRes() throws Exception {
        Reservation newres = new Reservation(-1, store.getBike(1), store.getCustomer(2), new Date());
        try {
            store.addReservation(newres, 120.00);
        } catch (AddReservationException are) {
            System.out.println("Bd. Wycofywanie transakcji.");
        }

    }
}
