drop database bikestore;

create database bikestore;

use bikestore;

create table bikes (
   bikeId int(11) not null auto_increment,
   manufacturer char(50) not null,
   model char(50) not null,
   frame int(11) not null default '0',
   serialNo char(20) not null,
   weight double not null default '0',
   status char(15) not null,
   primary key(bikeId)
);

create table customers (
     custId int(11) not null auto_increment,
     firstname char(50) not null,
     lastname char(50) not null,
     primary key (custId)
);

create table reservations (
      resId int(11) not null auto_increment,
      bikeId int(11) not null,
      custId int(11) not null,
      resDate date not null,
      primary key (resId)
);

create table eventLog (
   eventId int(11) not null auto_increment,
   methodname char(255) not null,
   datetime date not null,
   message char(255) not null,
   primary key (eventId)
);

insert into bikes values(1, "Shimano", "Roadmaster", 20, "11111", 15, "Dobry");
insert into bikes values(2, "Cannondale", "F2000 XTR", 18, "22222",12, "Doskonay");
insert into bikes values(3, "Trek","6000", 19, "33333", 12.4, "Dobry");

insert into customers values(1, "Justin", "Gehtland");
insert into customers values(2, "Bruce", "Tate");

insert into reservations values(1, 2, 2, '2004-09-15');
insert into reservations values(2, 3, 1, '2004-10-07');

insert into eventLog values(1, "testMethod", '2004-01-01', "test komunikat");
insert into eventLog values(2, "testMethod2", '2004-01-01', "test komunikat2");
