package com.springbook;

import net.sf.hibernate.Session;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

import java.util.Date;
import java.util.List;
import java.util.Set;

public class HibRentABike extends HibernateDaoSupport implements RentABike {
    private String name;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getBikes() {

        return getHibernateTemplate().find("from Bike");
    }

    // metoda pokazuje jedynie jak naleaoby wykonywa te seme operacje
    // bez wykorzystania szablonu
    public List getBikesOldWay() throws Exception {
        List bikes = null;
        Session s = null;
        try {
            s = getHibernateTemplate().getSessionFactory().openSession();
            bikes = s.find("from Bike");
        }catch (Exception ex) {
            // obsuga wyjtkw
        }finally {
            s.close();
        }
        return bikes;
    }

    public Bike getBike(String serialNo) {
        Bike b = null;
        List bikes = getHibernateTemplate().find("from Bike where serialNo = '" + serialNo + "'");
        if(bikes.size() > 0) {
            b = (Bike)bikes.get(0);
        }
        return b;
    }

    public Bike getBike(int bikeId) {
        return (Bike)getHibernateTemplate().load(Bike.class, new Integer(bikeId));
    }

    public void saveBike(Bike bike) {
        System.out.println("To save or update: " + bike);
        getHibernateTemplate().saveOrUpdate(bike);
    }

    public void deleteBike(Bike bike) {
        getHibernateTemplate().delete(bike);
    }

    public void setStoreName(String name) {
        this.name = name;
    }

    public String getStoreName() {
        return this.name;
    }

    public List getCustomers() {
       return getHibernateTemplate().find("from Customer");
    }

    public Customer getCustomer(int custId) {
       return (Customer)getHibernateTemplate().load(Customer.class, new Integer(custId));
    }

    public void saveCustomer(Customer customer) {
        getHibernateTemplate().saveOrUpdate(customer);
    }

    public void deleteCustomer(Customer customer) {
        getHibernateTemplate().delete(customer);
    }

    public List getReservations() {
        return getHibernateTemplate().find("from Reservation");
    }

    public List getReservations(Customer customer) {
        return getHibernateTemplate().find("from Reservation where custId = " + customer.getCustId());
    }

    public List getReservations(Bike bike) {
        return getHibernateTemplate().find("from Reservation where bikeId = " + bike.getBikeId());
    }

    public List getReservations(Date date) {
        return getHibernateTemplate().find("from Reservation where resdate = ?", date);
    }

    public Reservation getReservation(int resId) {
        return (Reservation)getHibernateTemplate().load(Reservation.class, new Integer(resId));
    }
}
