
import com.springbook.Bike;
import com.springbook.BikeValidator;
import com.springbook.BikesController;
import com.springbook.RentABike;
import junit.framework.TestCase;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.ModelAndView;

import java.sql.Connection;
import java.sql.DriverManager;


public class ControllerTest extends TestCase {
   private ApplicationContext ctx;
   public void setUp() throws Exception {
      ctx = new FileSystemXmlApplicationContext("war/WEB-INF/rentaBikeApp-servlet.xml");
   }
   public void testBikesController() throws Exception {
      BikesController controller = (BikesController) ctx.getBean("bikesController");
      ModelAndView mav = controller.handleRequest(null, null);
      RentABike store = (RentABike)mav.getModel().get("rentaBike");
      assertNotNull(store);
      assertEquals(3, store.getBikes().size());
   }

   public void testBikeValidator() throws Exception {
      BikeValidator v = (BikeValidator) ctx.getBean("bikeValidator");
      Bike bike = new Bike("test", "test", 1, "test", 2.00, "test");
      Errors errs = new BindException(bike, "bike");
      v.validate(bike, errs);
      assertFalse(errs.hasErrors());
      bike = new Bike();
      errs = new BindException(bike, "bike");
      v.validate(bike, errs);
      assertTrue(errs.hasErrors());
   }

   public void testJDBC() throws Exception {
      try {
         System.setProperty("jdbc.drivers", "com.mysql.jdbc.Driver");
         Connection conn = DriverManager.getConnection("jdbc:mysql://localhost/bikestore");
      } catch (Exception ex) {
         assertTrue(ex.getMessage().indexOf("authorization") > 0);
      }
      assertTrue(true); }
}
