package com.springbook;

import java.util.Date;
import java.util.List;

/**
 * @author Justin Gehtland
 * @version $Revision: 1.4 $ $Date: 2004/10/22 02:47:52 $
 */
public interface BikeStore {

    void setAccountsFacade(Accounts accounts);
    Accounts getAccountsFacade();

    void addReservation(Reservation reservation, double amount) throws AddReservationException;
    
    List getBikes();
    Bike getBike(String serialNo);
    Bike getBike(int bikeId);
    void saveBike(Bike bike);
    void deleteBike(Bike bike);
    void setStoreName(String name);
    String getStoreName();

    List getCustomers();
    Customer getCustomer(int custId);
    void saveCustomer(Customer customer);
    void deleteCustomer(Customer customer);

    List getReservations();
    List getReservations(Customer customer);
    List getReservations(Bike bike);
    List getReservations(Date date);
    Reservation getReservation(int resId);

    void transferReservation(final Reservation oldRes,final Reservation newRes) throws ReservationTransferException, Exception;
}
