package com.springbook;

import javax.servlet.http.HttpServletRequest;
import javax.faces.context.FacesContext;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/**
 * @author Justin Gehtland
 * @version $Revision: 1.4 $ $Date: 2004/10/22 02:47:52 $
 */
public class ArrayListBikeStore implements BikeStore {
    private String storeName;
    final List bikes = new ArrayList();

    public void saveBike(Bike bike) {
        if(bikes.contains(bike)) bikes.remove(bike);
        bikes.add(bike);
    }

    public void deleteBike(Bike bike) {
        bikes.remove(bike);
    }

    public ArrayListBikeStore() {
        initBikes();
    }

    public ArrayListBikeStore(String storeName) {
        this.storeName = storeName;
        initBikes();
    }

    private void initBikes() {
        bikes.add(new Bike(1, "Shimano", "Roadmaster", 20, "11111", 15, "Dobry"));
        bikes.add(new Bike(2, "Cannondale", "F2000 XTR", 18, "22222",12, "Doskonay"));
        bikes.add(new Bike(3, "Trek","6000", 19, "33333", 12.4, "Dobry"));
    }

    public String toString() {
        return "com.springbook.ArrayListBikeStore: " + storeName;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Accounts getAccountsFacade() {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public void addReservation(Reservation reservation, double amount) throws AddReservationException {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    public void setAccountsFacade(Accounts accounts) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    public List getBikes() {
        return bikes;
    }

    public Bike getBike(String serialNo) {
        Iterator iter = bikes.iterator();
        while(iter.hasNext()) {
            Bike bike = (Bike)iter.next();
            if(serialNo.equals(bike.getSerialNo())) return bike;
        }
        return null;
    }

    public Bike getBike(int bikeId) {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public List getCustomers() {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public Customer getCustomer(int custId) {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public void saveCustomer(Customer customer) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    public void deleteCustomer(Customer customer) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    public List getReservations() {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public List getReservations(Customer customer) {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public List getReservations(Bike bike) {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public List getReservations(Date date) {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public Reservation getReservation(int resId) {
        return null;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public void transferReservation(Reservation oldRes, Reservation newRes) {
        //To change body of implemented methods use File | Settings | File Templates.
    }
}
