
import junit.framework.TestCase;
import com.springbook.RentABike;
import com.springbook.ArrayListRentABike;
import com.springbook.Bike;

import java.util.List;
import java.util.Iterator;

public class RentABikeTest extends TestCase {
   private RentABike rentaBike;

   public void setUp() {
      rentaBike = new ArrayListRentABike("Rowery Bruce'a");
   }

   public void testGetName() {
      assertEquals("Rowery Bruce'a", rentaBike.getStoreName());
   }

   public void testGetBike() {
      Bike bike = rentaBike.getBike("11111");
      assertNotNull(bike);
      assertEquals("Shimano", bike.getManufacturer());
   }

   public void testGetBikes() {
      List bikes = rentaBike.getBikes();
      assertNotNull(bikes);
      assertEquals(3, bikes.size());
   }

   public void testDeleteBike() {
      List bikes = rentaBike.getBikes();
      assertEquals(3, bikes.size());
      Bike bike = (Bike)bikes.get(0);
      rentaBike.deleteBike(bike);
      bikes = rentaBike.getBikes();
      assertEquals(2, bikes.size());
   }

   public void testSaveBike() {
      Bike bike = (Bike)rentaBike.getBikes().get(0);
      assertEquals("Shimano", bike.getManufacturer());
      bike.setManufacturer("Royal");
      rentaBike.saveBike(bike);
      Iterator iter = rentaBike.getBikes().iterator();
      boolean found = false;
      while(iter.hasNext()) {
         Bike b = (Bike)iter.next();
         if(b.getManufacturer().equals("Royal")) found = true;
      }
      assertTrue(found);
   }


}
