
import com.springbook.Bike;
import com.springbook.Customer;
import com.springbook.RentABike;
import com.springbook.Reservation;
import junit.framework.TestCase;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

import java.util.Date;

public class TestJMSQueue extends TestCase {
   private ApplicationContext ctx;
   private RentABike store;

   public void setUp() throws Exception {
      ctx = new FileSystemXmlApplicationContext("war/WEB-INF/rentaBikeApp-servlet.xml");
      store = (RentABike)ctx.getBean("rentaBike");

   }

   public void testAddReservation() throws Exception {
      Bike bike = store.getBike(1);
      Customer customer = store.getCustomer(1);

      Reservation reservation = new Reservation(-1, bike, customer, new Date());

      store.addReservation(reservation, 100.00);

   }

   public void testGetBikesFromQueue() throws Exception {
      Bike b = store.getNewBikeFromQueue();
      assertEquals("Ventana", b.getManufacturer());
      assertEquals("El Chamuco", b.getModel());
      b = store.getNewBikeFromQueue();
      assertEquals("Ventana", b.getManufacturer());
      assertEquals("La Bruja", b.getModel());
      b = store.getNewBikeFromQueue();
      assertNull(b);
   }


}
