package com.springbook;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.view.RedirectView;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;


public class SubmitBikeController extends SimpleFormController {
    private RentABike facade;

    public RentABike getFacade() {
        return facade;
    }

    public void setFacade(RentABike facade) {
        this.facade = facade;
    }

    public ModelAndView onSubmit(Object command)
            throws ServletException{

        Bike bike = (Bike)command;
        facade.saveBike(bike);
        return new ModelAndView(new RedirectView(getSuccessView()), "bikeStore", facade);
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        Bike bike = new Bike();
        if(request.getParameter("bikeSerialNo") != null) bike = facade.getBike(request.getParameter("bikeSerialNo"));
        return bike;
    }

}
