package com.springbook.interceptors;

import com.springbook.LogEvent;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.Session;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

import java.util.Date;


public class LoggingAround implements MethodInterceptor {
   private SessionFactory factory;

   public SessionFactory getFactory() {
      return factory;
   }

   public void setFactory(SessionFactory factory) {
      this.factory = factory;
   }

   private void logEvent(String methodName, String message) throws Exception {
      LogEvent le = new LogEvent(methodName, new Date(), message);
      Session s = null;
      try {
         s = factory.openSession();
         s.save(le);
      } catch (Exception ex) {
         // rejestracja wyjtku
      } finally {
         s.close();
      }
   }

   public Object invoke(MethodInvocation methodInvocation) throws Throwable {
      final String methodName = methodInvocation.getMethod().getName();
      logEvent(methodName, "Przed wywoaniem.");
      Object result = methodInvocation.proceed();
      logEvent(methodName, "Po wywoaniu.");
      return result;
   }
}
