package com.springbook;

import org.springframework.validation.Validator;
import org.springframework.validation.Errors;

public class BikeValidator implements Validator {
    public boolean supports(Class aClass) {
        return aClass.equals(Bike.class);
    }

    public void validate(Object o, Errors errors) {
        Bike bike = (Bike)o;
        if(bike == null) {
            errors.rejectValue("manufacturer", "error.not-specified", null, "Wymagana warto.");
        } else {
            System.out.println("VALIDATOR: bike.manufacturer=" + bike.getManufacturer());
            if(bike.getManufacturer() == null || "".equals(bike.getManufacturer()))
                errors.rejectValue("manufacturer", "Nie podano wartoci.", null, "Naley okreli producenta.");
            if(bike.getModel() == null || "".equals(bike.getModel()))
                errors.rejectValue("model", "Nie podano wartoci.", null, "Naley okreli model.");
        }

    }
}
