<%@page contentType="text/html; charset=utf-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>

<html>
    <head>
        <title>Rezerwacja miejsc na <c:out value="${performance.show.name}"/></title>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    </head>

    <body>

        <b><c:out value="${performance.show.name}"/>:
        <fmt:formatDate value="${performance.dateAndTime}" type="date" pattern="EEEE MMMM dd, yyyy"/>
        </b>
        <br/>
        <p/>

        Zostało zarezerowanych <c:out value="${seatsCount}" /> miejsc. 
		Pozostaną one zarezerwowane przez 
        <c:out value="${minutesReservationWillBeValid}" /> minut.
		Oto numery zarezerwowanych miejsc

        <ul>
        <c:forEach items="${reservation.seats}" var="seat">
            <li><c:out value="${seat.name}"/></li>
        </c:forEach>
        </ul>


        <p/>
        Całkowita wartość zamówienia wynosi
        <fmt:formatNumber value="${reservation.booking.price}" type="currency"/>.
        Cena ta obejmuje koszt obsługi zamówienia w wysokości 
        <fmt:formatNumber value="${bookingFee}" type="currency"/> PLN.

        <p/>

        <c:if test="${!seatsAdjacent}" >
            <b>
			Proszę zauważyć, że w związku z dużym zainteresowaniem spektaklem nie udało się zarezerwować
			odpowiednio dużej grupy sąsiadujących ze sobą miejsc.
			</b>
        </c:if>

        <table>

            <tr>

                <td>
                    <form method="GET" action="displayShow.html">
                        <input type="hidden" name="showId" value="<c:out value="${performance.show.id}"/>"/>
                        <c:choose>
                            <c:when test="${!seatsAdjacent}" >
                                <input type="submit" value="Wybierz inny dzień"/>
                            </c:when >
                            <c:otherwise>
                                <input type="submit" value="Anuluj"/>
                            </c:otherwise >
                        </c:choose>
                    </form>
                </td>

                <td>
                    <form method="GET" action="payment.html">
                        <input type="hidden" name="bookingId" value="<c:out value="${reservation.booking.id}"/>"/>
                        <input type="hidden" name="performanceId" value="<c:out value="${performance.id}"/>"/>
                        <input type="submit" value="Dalej"/>
                    </form>

                </td>

            </tr>

        </table>

    </body>

</html>