package org.springframework.prospring.ticket.service.payment;

import org.springframework.prospring.ticket.service.*;

/**
 * Reprezentuje modu obsugujcy patnoci kart kredytow.
 */
public interface PaymentProcessor {

    /**
     * Weryfikuje szczegy dania zakupu dla danej patnoci.
     * @param purchaseRequest danie zakupu.
     * @throws CreditCardValidationException Zgaszany gdy dane karty kredytowej dla tej patnoci nie s prawidowe.
     */
    public void validate(PurchaseRequest purchaseRequest) throws CreditCardValidationException;

    /**
     * Przetwarza patno przy wykorzystaniu zewntrznego systemu obsugi patnoci.
     * @param purchaseRequest danie zakupu.
     * @return Kod potwierdzenia obsugi.
     */
    public String process(PurchaseRequest purchaseRequest) throws PaymentException;

}
