package org.springframework.prospring.ticket.service.payment;

import org.springframework.prospring.ticket.service.*;

/**
 * Wyjtek zgaszany gdy nie udao si przetworzy zapaty.
 *
 * @see PaymentProcessor#process(org.springframework.prospring.ticket.service.PurchaseRequest)
 */
public class PaymentException extends BaseApplicationException {

    public PaymentException(String errorCode) {
        super(errorCode);
    }

    public PaymentException(String message, String errorCode) {
        super(errorCode, message);
    }

    public PaymentException(Throwable cause, String errorCode) {
        super(errorCode, cause);
    }

    public PaymentException(String message, Throwable cause, String errorCode) {
        super(errorCode, message, cause);
    }

}
