package org.springframework.prospring.ticket.service.payment;

import org.springframework.prospring.ticket.service.*;

/**
 * To jest symulowana implementacja interfejsu mechanizmu sprawdzajcego poprawno karty kredytowej.
 * W losowy sposb akceptuje lub odrzuca karty i generuje losowe kodu uwierzytelniajce.
 */
public class DummyPaymentProcessor implements PaymentProcessor {

    // znaki z jakich bd generowane kody uwierzytelniajce.
    private final static char[] AUTH_CHARS = {
        'A', 'B', 'C', 'D', 'Y', 'Z', 'Q', 'T', 'J', 'R', 'W', 'V',
        '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'
    };

    /**
     * W losowy sposb akceptuje lub odrzuca dane danie zakupu.
     * @see PaymentProcessor#validate(org.springframework.prospring.ticket.service.PurchaseRequest)
     */
    public void validate(PurchaseRequest purchaseRequest) throws CreditCardValidationException {
        double randomNumber = Math.random() * 1000;
        if (randomNumber < 200) {
            throw new CreditCardValidationException("Numer karty kredytowej nie jest prawidowy.");
        }
    }

    /**
     * Generuje losowy kod uwierzytelniajcy.
     * @see PaymentProcessor#process(org.springframework.prospring.ticket.service.PurchaseRequest)
     */
    public String process(PurchaseRequest purchaseRequest) throws PaymentException {
        StringBuffer code = new StringBuffer();
        for (int i=0; i<10; i++) {
            int charIndex = (int)(Math.random() * AUTH_CHARS.length);
            code.append(AUTH_CHARS[charIndex]);
        }
        return code.toString();
    }

}
