package org.springframework.prospring.ticket.service.payment;

import org.springframework.prospring.ticket.service.*;

/**
 * Wyjtek zgaszany gdy numer karty kredytowej nie jest prawidowy.
 *
 * @see PaymentProcessor#validate(org.springframework.prospring.ticket.service.PurchaseRequest)
 */
public class CreditCardValidationException extends BaseApplicationException {

    // the kod bdu.
    private final static String ERROR_CODE = "payment.creditcard.invalid";

    public CreditCardValidationException(Throwable ex) {
        super(ERROR_CODE, ex);
    }

    public CreditCardValidationException(String message) {
        super(ERROR_CODE, message);
    }

}
