package org.springframework.prospring.ticket.service;

import org.springframework.prospring.ticket.domain.*;

/**
 * Reprezentuje rezerwacj.
 */
public class Reservation {

    // miejsca skojarzone z rezerwacj.
    private Seat[] seats;

    // szczegowe dane rezerwacji.
    private Booking booking;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabeans.
     */
    public Reservation() {
    }

    /**
     * Konstruktor - tworzy now rezerwacj dla okrelonych miejsc i z podanymi informacjami szczegowymi.
	 * @param seats Miejsca skojarzone z rezerwacj.
	 * @param booking Szczegowe informacje zwizane z rezerwacj.
	 */
	public Reservation(Seat[] seats, Booking booking) {
		this.seats = seats;
		this.booking = booking;
	}

    /**
     * Zwraca szczegowe informacje zwizane z rezerwacj.
     * @return Szczegowe informacje zwizane z rezerwacj.
     */
    public Booking getBooking() {
		return booking;
	}

    /**
     * Ustawia szczegowe informacje zwizane z rezerwacj.
     * @param booking Szczegowe informacje zwizane z rezerwacj.
     */
    public void setBooking(Booking booking) {
        this.booking = booking;
    }

    /**
     * Zwraca zarezerwowane miejsca.
     * @return Zarezerwowane miejsca.
     */
    public Seat[] getSeats() {
		return seats;
	}

    /**
     * Ustawia zarezerwowane miejsca.
     * @param seats Zarezerwowane miejsca.
     */
    public void setSeats(Seat[] seats) {
        this.seats = seats;
    }

}
