package org.springframework.prospring.ticket.service;

import org.springframework.prospring.ticket.domain.*;

/**
 * Reprezentuje bdu zgaszany podczas rezerwacji lub zamawiania miejsca, ktre
 * nie jest ju dostpne (czyli, ktre zostao ju zarezerwowane przez innego klienta).
 */
public class RequestedSeatNotAvailableException extends BaseApplicationException {

    private final static String ERROR_CODE = "seatNotAvailable";

    private Performance performance;

    public RequestedSeatNotAvailableException(Performance performance) {
        this("dane miejsca na przedstawienie " + performance.getShow().getName() + " nie s dostpne.", performance);
    }

    public RequestedSeatNotAvailableException(String message, Performance performance) {
        super(ERROR_CODE, message);
        this.performance = performance;
    }

    /**
     * Zwraca spektakl na jaki miay by zarezerwowane miejsca.
     * @return Spektakl na jaki miay by zarezerwowane miejsca.
     */
    public Performance getPerformance() {
        return performance;
    }

}
