package org.springframework.prospring.ticket.service;

import java.util.*;

import org.springframework.prospring.ticket.domain.*;

/**
 * Represents the event calendar of the system. The event calendar provides services regarding the
 * genres, shows, and performances available.
 * Reprezentuje kalendarz zdarze w systemie. Kalendarz ten dostarcza usug zwizanych z dostpnymi 
 * kategoriami przedstawie, przedstawieniamiami oraz spektaklami.
 */
public interface EventsCalendar {

    /**
     * Zwraca wszystkie zdefiniowane kategorie przedstawie.
     * @return Wszystkie zdefiniowane kategorie przedstawie.
     */
    public List getAllGenres();

    /**
     * Zwraca wszystkie przedstawienia dla jakich s zdefiniowane spektakle.
     * @return Wszystkie przedstawienia dla jakich s zdefiniowane spektakle.
     */
    public List getCurrentGenres();

    /**
     * Zwraca spektakl o podanym identyfikatorze.
     * @param performanceId Identyfikator danego spektaklu.
     * @return Spaktakl o podanym identyfikatorze.
     */
    public Performance getPerformance(long performanceId);

    /**
     * Zwraca przedstawienie o podanym identyfikatorze.
     * @param showId Identyfikator danego przedstawienia.
     * @return Przedstawienie o podanym identyfikatorze.
     */
    public Show getShow(long showId);
}
