package org.springframework.prospring.ticket.service;

import java.util.*;

/**
 * Zawiera szczegowe informacje zwizane z kart kredytow.
 */
public class CreditCardDetails {

    private final static String ENCRYPTED_PREFIX = "XXXX-XXXX-XXXX-";

    // typ karty (visa, master card, itd...)
    private String type;

    // nazwa waciciela zgodna z nadrukiem na karcie.
    private String nameOnCard;

    // numer karty kredytowej.
    private String cardNumber;

    // data wanoci karty kredytowej.
    private Date expiryDate;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabeans.
     */
    public CreditCardDetails() {
    }

    /**
     * Konstruktor - tworzy nowy obiekt zawierajcy szczegwe informacje o karcie kredytowej
     * @param type Typ karty kredytowej.
     * @param nameOnCard Personalia waciciela karty.
     * @param cardNumber Numer karty.
     * @param expiryDate Data wanoci karty.
     */
    public CreditCardDetails(String type, String nameOnCard, String cardNumber, Date expiryDate) {
        this.type = type;
        this.nameOnCard = nameOnCard;
        this.cardNumber = cardNumber;
        this.expiryDate = expiryDate;
    }

    /**
     * Zwraca typ karty kredytowej.
     * @return Typ karty kredytowej.
     */
    public String getType() {
        return type;
    }

    /**
     * Ustawia typ karty kredytowej.
     * @param type Typ karty kredytowej.
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * Zwraca nazw waciciela umieszczon na karcie.
     * @return Nazwa waciciela umieszczona na karcie kredytowej.
     */
    public String getNameOnCard() {
        return nameOnCard;
    }

    /**
     * Ustawia nazw waciciela widoczn na karcie kredytowej.
     * @param nameOnCard Nazwa waciciela widoczna na karcie kredytowej.
     */
    public void setNameOnCard(String nameOnCard) {
        this.nameOnCard = nameOnCard;
    }

    /**
     * Zwraca numer karty kredytowej..
     * @return Numer karty kredytowej.
     */
    public String getCardNumber() {
        return cardNumber;
    }

    /**
     * Zwraca zaszyfrowan wersj numeru karty kredytowej (ktr mona na przykad wywietli na witrynie).
     * @return Zaszyfrowana wersja numeru karty kredytowej (ktr mona na przykad wywietli na witrynie).
     */
    public String getEncryptedCardNumber() {
        String last4Numbers = cardNumber.substring(cardNumber.length()-4);
        return ENCRYPTED_PREFIX + last4Numbers;
    }

    /**
     * Ustawia numer karty kredytowej.
     * @param cardNumber Numer karty kredytowej.
     */
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    /**
     * Zwraca dat wyganicia wanoci karty kredytowej.
     * @return Data wyganicia wanoci karty kredytowej.
     */
    public Date getExpiryDate() {
        return expiryDate;
    }

    /**
     * Ustawia dat wyganicia wanoci karty kredytowej.
     * @param expiryDate Data wyganicia wanoci karty kredytowej.
     */
    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

}
