package org.springframework.prospring.ticket.service;

/**
 * Klasa bazowa wszystkich wyjtkw aplikacji
 */
public class BaseApplicationException extends ApplicationException {

    // kod bdu tego wyjtku.
    private String errorCode;

    /**
     * Konstruktor - tworzy nowy wyjtke aplikacji o podanym kodzie bdu.
     * @param errorCode Kod bdu wyjtku.
     */
    public BaseApplicationException(String errorCode) {
        this(errorCode, errorCode);
    }

    /**
     * Tworzy nowy wyjtek aplikacji.
     * @param errorCode Kod bdu wyjtku
     * @param message Komunikat wyjtku.
     */
    public BaseApplicationException(String errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    /**
     * Tworzy nowy wyjtek aplikacji.
     * @param errorCode Kod bdu wyjtku.
     * @param cause Przyczyna wyjtku.
     */
    public BaseApplicationException(String errorCode, Throwable cause) {
        this(errorCode, errorCode, cause);
    }

    /**
     * Tworzy nowy wyjtek aplikacji.
     * @param errorCode Kod bdu wyjtku
     * @param message komunikat wyjtku.
     * @param cause Przyczyna wyjtku.
     */
    public BaseApplicationException(String errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    /**
     * Zwraca kod bdu wyjtku.
     * @return Kod bdu wyjtku.
     * @see ApplicationException#getErrorCode()
     */
    public String getErrorCode() {
        return errorCode;
    }

}
