
package org.springframework.prospring.ticket.service;

import org.springframework.core.*;

/**
 * Kasa bazowa dla wszystkich wyjtkw zgaszanych w aplikacji.
 */
public abstract class ApplicationException extends Exception implements ErrorCoded {

	/**
	 * Konstruktor klasy ApplicationException.
	 * @param message Komunikat wyjtku.
	 */
	public ApplicationException(String message) {
		super(message);
	}

	/**
	 * Konstruktor klasy ApplicationException.
	 * @param message Komunikat wyjtku.
	 * @param cause Przyczyna wyjtku.
	 */
	public ApplicationException(String message, Throwable cause) {
		super(message, cause);
	}


}
