package org.springframework.prospring.ticket.domain;

import org.springframework.util.*;

/**
 * Reprezentuje kategori (typ) miejsca w systemie aplikacji.
 */
public class SeatClass {

    // identyfiaktor kategorii miejsc.
    private long id;

    // kod kategorii miejsc.
    private String code;

    // opis kategorii miejsc.
    private String description;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabean.
     */
    public SeatClass() {
    }

    /**
     * Konstruktor - tworzy nowy obiket o podanym kodzie i opisie.
     * @param code Kod kategori miejsc.
     * @param description Opis kategorii miejsc.
     */
    public SeatClass(String code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * Zwraca identyfikator kategorii miejsc.
     * @return Identyfikator kategorii miejsc.
     */
    public long getId() {
        return id;
    }

    /**
     * Ustawia identyfikator kategorii miejsc.
     * @param id Identyfikator kategorii miejsc.
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * Zwraca kod kategorii miejsc.
     * @return Kod kategorii miejsc.
     */
    public String getCode() {
        return code;
    }

    /**
     * Ustawia kod kategorii miejsc.
     * @param code Kod kategorii miejsc.
     */
    public void setCode(String code) {
        this.code = code;
    }

    /**
     * Zwraca opis kategorii miejsc.
     * @return Opis kategorii miejsc.
     */
    public String getDescription() {
        return description;
    }

    /**
     * Ustawia opis kategorii miejsc.
     * @param description Opis kategorii miejsc.
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @see Object#equals(Object)
     */
    public boolean equals(Object o) {

        if (this == o) {
            return true;
        }

        if (!(o instanceof SeatClass)) {
            return false;
        }

        SeatClass seatClass = (SeatClass) o;

        return ObjectUtils.nullSafeEquals(code, seatClass.code) &&
            ObjectUtils.nullSafeEquals(description, seatClass.description);
    }

    /**
     * @see Object#hashCode()
     */
    public int hashCode() {
        int result = (code != null) ? code.hashCode() : 0;
        result = 31 * result + ((description != null) ? description.hashCode() : 0);
        return result;
    }
}
