package org.springframework.prospring.ticket.domain;

/**
 * Reprezentuje miejsce w systemie aplikacji.
 */
public class Seat {

    // identyfikator miejsca.
    private long id;

    // nazwa miejsca.
    private String name;

    // miejsce pooone z lewej strony tego miejsca.
    private Seat leftSide;

    // miejsce pooone z prawej strony tego miejsca.
    private Seat rightSide;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabean.
     */
    public Seat() {
    }

    /**
     * Konstruktor - tworzy nowe miejsce o podanej nazwie.
     * @param name Nazwa miejsca.
     */
    public Seat(String name) {
        this.name = name;
    }

    /**
     * Zwraca identyfikator miejsca.
     * @return Identyfikator miejsca.
     */
    public long getId() {
		return id;
	}

    /**
     * Ustawia identyfikator miejsca.
     * @param id Identyfikator miejsca.
     */
    public void setId(long id) {
		this.id = id;
	}

    /**
     * Zwraca nazw miejsca.
     * @return Nazwa miejsca.
     */
    public String getName() {
        return name;
    }

    /**
     * Ustawia nazw miejsca.
     * @param name Nazwa miejsca.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Zwraca miejsce z lewej.
     * @return Miejsce z lewej lub null jeli takiego miejsca nie ma.
     */
    public Seat getLeftSide() {
		return leftSide;
	}

    /**
     * Ustawia miejsce z lewej.
     * @param leftSide Miejsce z lewej strony tego miejsca.
     */
    public void setLeftSide(Seat leftSide) {
		this.leftSide = leftSide;
	}


    /**
     * Zwraca miejsce z prawej.
     * @return Miejsce z prawej lub null jeli takiego miejsca nie ma.
     */
    public Seat getRightSide() {
		return rightSide;
	}

    /**
     * Ustawia miejsce z prawej.
     * @param rightSide Miejsce z prawej strony tego miejsca.
     */
    public void setRightSide(Seat rightSide) {
		this.rightSide = rightSide;
	}

}
