package org.springframework.prospring.ticket.domain;

/**
 * Reprezentuje zarejestrowanego uytkownika aplikacji.
 */
public class RegisteredUser {

    // identyfikator uytkownika.
    private long id;

    // adres poczty elektronicznej uytkownika.
    private String email;

    // haso uytkownika.
    private String password;

    // adres do rozlicze finansowych z uytkownikiem.
    private Address billingAddress;

    // adres wysyki dla tego uytkownika.
    private Address deliveryAddress;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabean.
     */
    public RegisteredUser() {
    }

    /**
     * Konstruktor - tworzy nowego zarejestroanego uytkownika o podanym adresie poczty elektronicznej,
     * hale oraz adresie do rozlicze. Domylny adres wysyki bdzie taki sam jak adres do rozlicze.
     * @param email Adres poczty elektronicznej uytkownika.
     * @param password Has uytkownika.
     * @param billingAddress Adres do rozlicze (oraz wysyki) z tym uytkownikiem.
     */
    public RegisteredUser(String email, String password, Address billingAddress) {
        this(email, password, billingAddress, billingAddress);
    }

    /**
     * Konstruktor - tworzy nowego zarejestroanego uytkownika o podanym adresie poczty elektronicznej,
     * hale, adresie do rozlicze oraz adresie wysyki.
     * @param email Adres poczty elektronicznej uytkownika.
     * @param password Has uytkownika.
     * @param billingAddress Adres do rozlicze z tym uytkownikiem.
     * @param deliveryAddress Adres wysyki dla tego uytkownika.
     */
    public RegisteredUser(String email, String password, Address billingAddress, Address deliveryAddress) {
        this.email = email;
        this.password = password;
        this.billingAddress = billingAddress;
        this.deliveryAddress = deliveryAddress;
    }

    /**
     * Zwraca identyfikator uytkownika.
     * @return Identyfikator uytkownika.
     */
    public long getId() {
        return id;
    }

    /**
     * Ustawia identyfikator uytkownika.
     * @param id Identyfikator uytkownika.
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * Zwraca adres poczty elektronicznej uytkownika.
     * @return Adres poczty elektronicznej uytkownika.
     */
    public String getEmail() {
        return email;
    }

    /**
     * Ustawia adres poczty elektronicznej uytkownika.
     * @param email Adres poczty elektronicznej uytkownika.
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * Zwraca haso uytkownika.
     * @return Haso uytkownika.
     */
    public String getPassword() {
        return password;
    }

    /**
     * Ustawia haso uytkownika.
     * @param password Haso uytkownika.
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * Zwraca adres do rozlicze z tym uytkownikem.
     * @return Adres do rozlicze.
     */
    public Address getBillingAddress() {
        return billingAddress;
    }

    /**
     * Ustawia adres do rozlicze z tym uytkownikiem.
     * @param billingAddress Adres do rozlicze z tym uytkownikiem.
     */
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    /**
     * Zwraca adres wysyki dla tego uytkownika.
     * @return Adres wysyki.
     */
    public Address getDeliveryAddress() {
        return deliveryAddress;
    }

    /**
     * Ustawia adres wysyki dla tego uytkownika.
     * @param deliveryAddress Adres wysyki do tego uytkownika.
     */
    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

}
