package org.springframework.prospring.ticket.domain;

import java.math.*;

/**
 * Reprezentuje grup cenow. Grupa cenowa kojarzy cen z kategori miejsc.
 */
public class PriceBand {

    // identyfikator grupy cenowej.
    private long id;

    // cena skojarzona z grup cenow.
    private BigDecimal price;

    // kategoria miejsc skojarzona z grup cenow.
    private SeatClass seatClass;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabean.
     */
    public PriceBand() {
	}

    /**
     * Konstruktor - tworzy now grup cenow na podstawie podanej kategorii miejsc i ceny.
     * @param seatClass Kategoria miejsc.
     * @param price Cena.
     */
    public PriceBand(SeatClass seatClass, BigDecimal price) {
		this(0, seatClass, price);
    }

    /**
     * Konstruktor - tworzy now grup cenow na podstawie podanej kategorii miejsc, identyfikatora i ceny.
     * @param id Identyfikator.
     * @param seatClass Kategoria miejsc.
     * @param price Cena.
     */
    public PriceBand(long id, SeatClass seatClass, BigDecimal price) {
        this.id = id;
        this.seatClass = seatClass;
        this.price = price;
    }

    /**
     * Zwraca identyfikator tej grupy cenowej.
     * @return Identyfikator tej grupy cenowej.
     */
    public long getId() {
		return id;
	}

    /**
     * Ustawia identyfikator tej grupy cenowej.
     * @param id Identyfikator tej grupy cenowej.
     */
    public void setId(long id) {
		this.id = id;
	}

    /**
     * Zwraca cene dla tej grupy cenowej.
     * @return Cena dla tej grupy cenowej.
     */
    public BigDecimal getPrice() {
		return price;
	}

    /**
     * Ustawia cen dla tej grupy cenowej.
     * @param price Cena dla tej grupy cenowej.
     */
    public void setPrice(BigDecimal price) {
		this.price = price;
	}

    /**
     * Returns the seat class that is associated with this price band.
     * Zwraca kategori miejsc skojarzon z t grup cenow.
     * @return Kategoria miejsc skojarzona z t grup cenow.
     */
    public SeatClass getSeatClass() {
		return seatClass;
	}

    /**
     * Ustawia kategori miejsc skojarzon z t grup cenow.
     * @param seatClass Kategoria miejsc skojarzona z t grup cenow.
     */
    public void setSeatClass(SeatClass seatClass) {
		this.seatClass = seatClass;
	}
}
