package org.springframework.prospring.ticket.domain;

import java.util.*;

/**
 * Repreznetuje konkretny spektakl pewnego przedstawienia.
 */
public class Performance {

    // identyfikator spektaktlu.
    private long id;

    // data spektaklu.
    private Date dateAndTime;

    // struktura cen dla spektaklu.
    private PriceStructure priceStructure;

    // przedstawienie.
    private Show show;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabean.
     */
    public Performance() {
	}

    /**
     * Konstruktor - tworzy nowy spektakl dla podanego przedstawienia, daty i struktury cen.
     * @param show Przedstawienie.
     * @param dateAndTime Data spaktaklu.
     * @param priceStructure Struktura cen dla tego spektaklu.
     */
    public Performance(Show show, Date dateAndTime, PriceStructure priceStructure) {
        this(0, show, dateAndTime, priceStructure);
    }

    /**
     * Constructs a new performance with given id, show, date and price structure.
     * Konstruktor - tworzy nowy spektakl o podanym identyfikatorze dla podanego przedstawienia, daty i struktury cen.
     * @param id Identyfikator spektaklu.
     * @param show Przedstawienie.
     * @param dateAndTime Data spektaklu.
     * @param priceStructure Struktura cen dla tego spektaklu.
     */
    public Performance(long id, Show show, Date dateAndTime, PriceStructure priceStructure) {
        this.id = id;
        this.show = show;
        this.dateAndTime = dateAndTime;
        this.priceStructure = priceStructure;
    }
    
    /**
     * Zwraca identyfiaktor spektaklu.
     * @return Identyfiaktor spektaklu.
     */
    public long getId() {
        return id;
    }

    /**
     * Ustawia identyfiaktor spektaklu.
     * @param id Identyfiaktor spektaklu.
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * Zwraca dat spektaklu.
     * @return Data spektaklu.
     */
    public Date getDateAndTime() {
        return dateAndTime;
    }

    /**
     * Ustawia dat spektaklu.
     * @param dateAndTime Data spektaklu.
     */
    public void setDateAndTime(Date dateAndTime) {
        this.dateAndTime = dateAndTime;
    }

    /**
     * Zwraca struktur cen dla tego spektaklu.
     * @return Struktura cen dla tego spektaklu.
     */
    public PriceStructure getPriceStructure() {
        return priceStructure;
    }

    /**
     * Ustawia struktur cen dla tego spektaklu.
     * @param priceStructure Struktura cen dla tego spektaklu.
     */
    public void setPriceStructure(PriceStructure priceStructure) {
        this.priceStructure = priceStructure;
    }

    /**
     * Zwraca przedstawienie.
     * @return Przedstawienie.
     */
    public Show getShow() {
        return show;
    }

    /**
     * Ustawia przedstawienie.
     * @param show Przedstawienie.
     */
    public void setShow(Show show) {
        this.show = show;
    }

}
