package org.springframework.prospring.ticket.domain;

import java.util.*;

/**
 * Reprezentuje kategori przedstawie.
 */
public class Genre {

    // identyfiaktor kategorii
    private long id;

    // nazwa kategorii
    private String name;

    // przedstawienia nalece do tej kategorii
    private Set shows;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabean.
     */
    public Genre() {
        shows = new HashSet();
    }

    /**
     * Konstruktor - tworzy nowy obiekt kategorii o podanej nazwie.
     * @param name Nazwa kategorii.
     */
    public Genre(String name) {
        shows = new HashSet();
        this.name = name;
    }

    /**
     * Zwraca identyfikator kategorii.
     * @return Identyfikator kategorii.
     */
    public long getId() {
        return id;
    }

    /**
     * Ustawia identyfikator kategorii.
     * @param id Identyfikator kategorii.
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * Zwraca nazw kategorii.
     * @return Nazwa kategorii.
     */
    public String getName() {
        return name;
    }

    /**
     * Ustawia nazw kategorii.
     * @param name Nazwa kategorii.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Zwraca przedstawienia nalece do tej kategorii.
     * @return Przedstawienia nalece do tej kategorii.
     */
    public Set getShows() {
        return shows;
    }

    /**
     * Ustawia przedstawienia nalece do tej kategorii.
     * @param shows Przedstawienia nalece do tej kategorii.
     */
    public void setShows(Set shows) {
        this.shows = shows;
    }

    /**
     * Dodaje przedstawienie do tej kategorii.
     * @param show Przedstawienie jakie naley doda do kategorii
     */
    public void addShow(Show show) {
        shows.add(show);
    }

    /**
     * Usuwa przekazane przedstawienie z tej kategorii.
     * @param show Przedstawienie jakie naley usun z tej kategorii.
     */
    public void removeShow(Show show) {
        shows.remove(show);
    }

}
