package org.springframework.prospring.ticket.domain;

import org.springframework.util.*;

/**
 * Reprezentuje adres w aplikacji.
 */
public class Address {

    // kraj.
    private String country;

    // miasto.
    private String city;

    // ulica.
    private String street;

    // kod pocztowy.
    private String postcode;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabean.
     */
    public Address() {
    }

    /**
     * Konstruktor - tworzy nowy adres
     * @param country Kraj.
     * @param city Miasto.
     * @param street Ulica.
     * @param postcode Kod pocztowy.
     */
    public Address(String country, String city, String street, String postcode) {
        this.country = country;
        this.city = city;
        this.street = street;
        this.postcode = postcode;
    }

    /**
     * Zwraca kraj adresu.
     * @return Kraj adresu.
     */
    public String getCountry() {
        return country;
    }

    /**
     * Ustawia kraj adresu.
     * @param country Kraj adresu.
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /**
     * Zwraca miasto adresu.
     * @return Miasto adresu.
     */
    public String getCity() {
        return city;
    }

    /**
     * Ustawia miasto adresu.
     * @param city Miasto adresu.
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * Zwraca ulic adresu.
     * @return Ulica adresu.
     */
    public String getStreet() {
        return street;
    }

    /**
     * Ustawia ulic adresu.
     * @param street Ulica adresu.
     */
    public void setStreet(String street) {
        this.street = street;
    }

    /**
     * Zwraca kod pocztowy adresu.
     * @return Kod pocztowy adresu.
     */
    public String getPostcode() {
        return postcode;
    }

    /**
     * Ustawia kod pocztowy adresu.
     * @param postcode Kod pocztowy adresu.
     */
    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    /**
     * @see Object#equals(Object)
     */
    public boolean equals(Object o) {

        if (this == o) {
            return true;
        }

        if (!(o instanceof Address)) {
            return false;
        }

        Address address = (Address)o;

        return ObjectUtils.nullSafeEquals(city, address.city) &&
            ObjectUtils.nullSafeEquals(country, address.country) &&
            ObjectUtils.nullSafeEquals(postcode, address.postcode) &&
            ObjectUtils.nullSafeEquals(street, address.street);
    }

    /**
     * @see Object#hashCode()
     */
    public int hashCode() {
        int result = (country != null) ? country.hashCode() : 0;
        result = 31 * result + ((city != null) ? city.hashCode() : 0);
        result = 31 * result + ((street != null) ? street.hashCode() : 0);
        result = 31 * result + ((postcode != null) ? postcode.hashCode() : 0);
        return result;
    }
}
