<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>

<html>

    <head>
		<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <title>Bilety zamówione na spektakl <c:out value="${performance.show.name}"/></title>
    </head>

    <body>
        <b>
            Twoje zamówienie na bilety na spektakl<c:out value="${performance.show.name}"/> <br/>
            dnia <fmt:formatDate value="${performance.dateAndTime}" pattern="EEEEEE MMMMM d, yyyy"/>, 
			zostało zatwierdzone.
        </b>

        <p/>

        Twoja karta kredytowa, o numerze <c:out value="${purchase.encryptedCardNumber}"/> zostanie obciążona kwotą <c:out value="${reservation.booking.price}"/>PLN.

        <p/>

        Zarezerwowane zostały następujące miejsca
        <c:forEach items="${reservation.seats}" var="seat" varStatus="status">
            <c:if test="${status.count > 1}">; </c:if>
            <c:out value="${seat.name}"/>
        </c:forEach>

        <p/>

        <c:choose>

            <c:when test="${!purchase.userCollected}">
                Zamówione bilety zostaną przesłane na poniższy adres pocztowy:
                <br/><br/>
                <c:out value="${purchase.customerName}"/><br/>
                <c:choose>
                    <c:when test="${!useBillingAddressForDelivery}">
                        <c:out value="${purchase.deliveryAddress.street}"/><br/>
                        <c:out value="${purchase.deliveryAddress.city}"/><br/>
                        <c:out value="${purchase.deliveryAddress.country}"/><br/>
                        <c:out value="${purchase.deliveryAddress.postcode}"/>
                    </c:when>
                    <c:otherwise>
                        <c:out value="${purchase.billingAddress.street}"/><br/>
                        <c:out value="${purchase.billingAddress.city}"/><br/>
                        <c:out value="${purchase.billingAddress.country}"/><br/>
                        <c:out value="${purchase.billingAddress.postcode}"/>
                    </c:otherwise>
                </c:choose>
            </c:when>

            <c:otherwise>
                    Twoje bilety będą do odbioru w kasie teatru.
            </c:otherwise>

        </c:choose>
        <p/>

        <b>Numer zamówienia to <c:out value="${purchase.paymentAuthorizationCode}"/>.</b>
		Proszę go zachować (można wydrukować tę stronę), gdyż będzie konieczny w razie ewentualnych
		zapytań kierowanych do pracowników teatru lub konieczności odwołania zamówienia.

        Potwierdzenie zamówienia zostanie przesłane pocztą elektroniczną na adres <c:out value="${purchase.email}"/>.

        <p/>
        <p/>

        <a href="listShows.html">Powrót na stronę główną</a>

    </body>
</html>