package org.springframework.prospring.ticket.web.confirmation;

import org.springframework.prospring.ticket.domain.*;
import org.springframework.prospring.ticket.service.*;

/**
 * Strategia wysyania potwierdze zamwie.
 * Stanowi abstrakcj postaci w jakiej jest wysyane potwierdzenie.
 */
public interface PurchaseConfirmationSender {

    /**
     * Wysya komunikat stanowicy potwierdzenie zamwienia.
     * @param purchase Potwierdzane zakupu.
     * @throws PurchaseConfirmationSendingException
     */
    public void sendPurchaseConfirmation(Purchase purchase, PurchaseRequest purchaseRequest)
        throws PurchaseConfirmationSendingException;

}
