package org.springframework.prospring.ticket.web.confirmation;

import org.springframework.prospring.ticket.domain.*;
import org.springframework.prospring.ticket.service.*;
import org.apache.commons.logging.*;

/**
 * Ta imitacja usugi wysyajcej potwierdzenia zamwienia ogranicza swe dziaanie
 * jedynie do zarejestrowania wywoania.
 */
public class DummyMailPurchaseConfirmationSender implements PurchaseConfirmationSender {

    private final static Log logger = LogFactory.getLog(DummyMailPurchaseConfirmationSender.class);

    public void sendPurchaseConfirmation(Purchase purchase, PurchaseRequest purchaseRequest)
        throws PurchaseConfirmationSendingException {

        if (logger.isInfoEnabled()) {
            logger.info("Wysyanie wiadomoci z potwierdzeniem zamwienia nr. " + purchase.getId());
        }
    }
}
