package org.springframework.prospring.ticket.web;

import java.util.*;

import javax.servlet.http.*;

import org.springframework.prospring.ticket.service.*;
import org.springframework.web.servlet.*;
import org.springframework.web.servlet.mvc.*;

/**
 * Kontroler pobierajcy list rodzajw przedstawie z bazy
 * Dane wejciowe: brak<p>
 * Model:
 * <ul>
 *  <li><code>genres</code>: lista kategorii</li>
 * </ul>
 */
public class ListShowsController extends AbstractController {

	// uywana usuga kalendarza zdarze.
    private EventsCalendar eventsCalendar;

    // nazwa widoku zwracanego przez kontroler.
    private String viewName;

    /**
     * @see AbstractController#handleRequestInternal(
     *      javax.servlet.http.HttpServletRequest,
            javax.servlet.http.HttpServletResponse)
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Collection genres = eventsCalendar.getCurrentGenres();

        if (logger.isDebugEnabled()) {
            logger.debug("Kategorie: " + genres.size());
        }

    	return new ModelAndView(viewName, "genres", genres);
    }

    /**
     * Ustawia kalendarz zdarze jakiego powinien uywa ten kontroler.
     * @param eventsCalendar Kalendarz zdarze jakiego powinien uywa ten kontroler.
     */
    public void setEventsCalendar(EventsCalendar eventsCalendar) {
        this.eventsCalendar = eventsCalendar;
    }

    /**
     * Ustawia nazw widoku zwracanego przez ten kontroler.
     * @param viewName Nazwa widoku zwracanego przez ten kontroler.
     */
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

}
