package org.springframework.prospring.ticket.service;

import org.springframework.prospring.ticket.domain.*;

/**
 * Reprezentuje danie zakupu biletw na spektakl.
 */
public class PurchaseRequest {

    // rezerwacja skojarzona z daniem.
    private Reservation reservation;

    // spektakl skojarzony z daniem.
    private Performance performance;

    // szczegowe informacje dotyczce karty kredytowej.
    private CreditCardDetails creditCardDetails;

    // adres do rozlicze.
    private Address billingAddress;

    // adres wysyki.
    private Address deliveryAddress;

    // adres poczty elektronicznej uytkownika dokonujcego zamwienia.
    private String email;

    // okrela czy uytkownik sam odbierze bilety.
    private boolean collect;

    /**
     * Konstruktor.
     */
    public PurchaseRequest() {
    }

    /**
     * Zwraca rezerwacj skojarzon z daniem zakupu.
     * @return Rezerwacja skojarzona z daniem zakupu.
     */
    public Reservation getReservation() {
        return reservation;
    }

    /**
     * Ustawia rezerwacj skojarzon z daniem zakupu.
     * @param reservation Rezerwacja skojarzona z daniem zakupu.
     */
    public void setReservation(Reservation reservation) {
        this.reservation = reservation;
    }

    /**
     * Zwraca spektakl skojarzony z tym daniem.
     * @return Spektakl skojarzony z tym daniem.
     */
    public Performance getPerformance() {
        return performance;
    }

    /**
     * Ustawia spektakl skojarzony z tym daniem.
     * @param performance Spektakl skojarzony z tym daniem.
     */
    public void setPerformance(Performance performance) {
        this.performance = performance;
    }

    /**
     * Zwraca szczegwe informacje o kartcie kredytowej.
     * @return Szczegwe informacje o kartcie kredytowej.
     */
    public CreditCardDetails getCreditCardDetails() {
        return creditCardDetails;
    }

    /**
     * Ustawia szczegwe informacje o kartcie kredytowej.
     * @param creditCardDetails Szczegwe informacje o kartcie kredytowej.
     */
    public void setCreditCardDetails(CreditCardDetails creditCardDetails) {
        this.creditCardDetails = creditCardDetails;
    }

    /**
     * Zwraca adres do rozlicze dla tego dania zakupu.
     * @return Adres do rozlicze dla tego dania zakupu.
     */
    public Address getBillingAddress() {
        return billingAddress;
    }

    /**
     * Ustawia adres do rozlicze dla tego dania zakupu.
     * @param billingAddress Adres do rozlicze dla tego dania zakupu.
     */
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    /**
     * Zwraca adres wysyki dla tego dania zakupu.
     * @return Adres wysyki dla tego dania zakupu, null jeli adres wysyki jest taki sam
     * jak adres do rozlicze.
     */
    public Address getDeliveryAddress() {
        return deliveryAddress;
    }

    /**
     * Ustawia adres wysyki dla tego dania zakupu.
     * @param deliveryAddress Adres wysyki dla tego dania zakupu.
     */
    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    /**
     * Zwraca adres poczty elektronicznej uytkownika, ktry dokona zamwienia.
     * @return Adres poczty elektronicznej uytkownika.
     */
    public String getEmail() {
        return email;
    }

    /**
     * Ustawia adres poczty elektronicznej uytkownika, ktry dokona zamwienia.
     * @param email Adres poczty elektronicznej uytkownika.
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * Zwraca warto logiczn okrelajc czy uytkownik sam odbierze zamwione bilety czy naley je wysa.
     * @return true jeli uytkownik sam odbierze bilety, false jeli naley je wysa poczt.
     */
    public boolean isCollect() {
        return collect;
    }

    /**
     * Okrela czy uytkownik sam odbierze bilety, czy te naley je do niego wysa poczt.
     * @param collect Warto okrelajca czy uytkownik sam odbierze bilety czy naley je wysa.
     */
    public void setCollect(boolean collect) {
        this.collect = collect;
    }

}
