
package org.springframework.prospring.ticket.service;

/**
 * Reprezentuje bd zgaszany podczas tworzenia rezerwacji i informujcy o braku niezbdnej 
 * iloci miejsc.
 */
public class NotEnoughSeatsException extends BaseApplicationException {

    public final static String ERROR_CODE = "notEnoughSeats";

    private int requested;
	
	private int available;
	
	private long classId;

    /**
     *
     * @param classId Identyfikator kategorii miejsc.
     * @param requested Ilo danych miejsc.
     * @param available Ilo dostpnych miejsc.
     */
	public NotEnoughSeatsException(long classId, int available, int requested) {
		super(ERROR_CODE, "Zadano " + requested + " miejsc klasy " + classId + "; dostpne s jedynie " + available + " miejsca.");
		this.classId = classId;
		this.requested = requested;
        this.available = available;
    }
	
	public int getRequested() {
		return requested;
	}

    public int getAvailable() {
        return available;
    }

    public long getClassId() {
		return classId;
	}

}
