package org.springframework.prospring.ticket.service;

import java.util.*;

import org.springframework.prospring.ticket.dao.*;
import org.springframework.prospring.ticket.domain.*;

/**
 * Domylna implementacja usugi EventsCalendar.
 */
public class EventsCalendarImpl implements EventsCalendar {

    // DAO ktrego ta usug uywa do pobierania informacji z bazy danych.
    private BoxOfficeDao boxOfficeDao;

    /**
     * Returns all genres which currently have shows.
     * Zwraca wszystkie kategorie przedstawie dla jakich aktualnie s zdefinowane spektakle.
     * @return Wszystkie kategorie przedstawie dla jakich aktualnie s zdefinowane spektakle.
     */
    public List getCurrentGenres() {
        return boxOfficeDao.getCurrentGenres();
    }

    /**
     * Zwraca wszystkie zdefiniowane kategorie przedstawie.
     * @return Wszystkie kategorie przedstawie zdefiniowane w systemie.
     */
    public List getAllGenres() {
        return boxOfficeDao.getAllGenres();
    }

    /**
     * Zwraca przedstawienie o podanym identyfikatorze.
     * @param performanceId Identyfikator danego przedstawienia.
     * @return Przedstawienie o podanym identyfikatorze.
     */
    public Performance getPerformance(long performanceId) {
        return boxOfficeDao.getPerformance(performanceId);
    }

    /**
     * Zwraca spektakl o podanym identyfikatorze.
     *
     * @param showId Identyfikator danego spektaklu.
     * @return Spektakl o podanym identyfikatorze.
     */
    public Show getShow(long showId) {
        return boxOfficeDao.getShow(showId);
    }

    /**
     * Ustawia obiekt DAO uywane przez t usug do pobierania informacji z bazy.
     * @param boxOfficeDao Obiekt DAO uywany do pobierania informacji z bazy.
     */
    public void setBoxOfficeDao(BoxOfficeDao boxOfficeDao) {
        this.boxOfficeDao = boxOfficeDao;
    }

}
