package org.springframework.prospring.ticket.domain.support;

import java.util.*;

import org.springframework.prospring.ticket.domain.*;

/**
 * Spektakl zawierajcy informacje o dostpnych miejscach.
 */
public class PerformanceWithAvailability extends Performance {

    // ilo miejsc dostpnych na ten spektakl.
    private int availableSeatCount;

    // lista obiektw PriceBandWithAvailabilaty dla tego spektaklu.
    private List priceBandWithAvailability;

	/**
     * Konstruktor - tworzy nowy obiekt spektaklu wraz z informacjami o dostpnych miejscach.
	 * @param id Identyfikator spektaklu.
	 * @param dateAndTime Data spektaklu.
	 * @param priceStructure Struktura cen dla spektaklu.
	 * @param show Przedstawienie.
	 */
	public PerformanceWithAvailability(
        long id,
        Date dateAndTime,
		PriceStructure priceStructure,
        Show show) {

        super(id, show, dateAndTime, priceStructure);
        this.availableSeatCount = 0;
        this.priceBandWithAvailability = new LinkedList();
	}

    public PerformanceWithAvailability(Performance performance) {
        super(performance.getId(), performance.getShow(), performance.getDateAndTime(), performance.getPriceStructure());
        availableSeatCount = 0;
        priceBandWithAvailability = new LinkedList();
    }

    /**
     * Zwraca ilo dostpnych miejsc na ten spektakl.
     * @return Ilo dostpnych miejsc na ten spektakl.
     */
    public int getAvailableSeatCount() {
		return availableSeatCount;
	}

    /**
     * Zwraca list obiektw PriceBandWithAvailability dla danego spektaklu.
     * @return Lista obiektw PriceBandWithAvailability dla danego spektaklu.
     */
    public List getPriceBandWithAvailability() {
		return priceBandWithAvailability;
	}

    /**
     * Dodaje przekazany obiekt PriceBandWithAvailability do tego spektaklu.
     * @param priceBandWithAvailability Obiekt PriceBandWithAvailability, ktry naley doda do tego spektaklu.
     */
    public void add(PriceBandWithAvailability priceBandWithAvailability) {
		this.availableSeatCount += priceBandWithAvailability.getAvailableSeatCount();
		this.priceBandWithAvailability.add(priceBandWithAvailability);
	}
}
