package org.springframework.prospring.ticket.domain;

import java.util.*;

/**
 * Reprezentuje przedstawienie.
 */
public class Show {

    // identyfikator przedstawienia.
    private long id;

    // nazwa przedstawienia.
    private String name;

    // zbir spektakli tego przedstawienia.
    private Set performances;

    // plan miejsc dla tego przedstawienia.
    private SeatingPlan seatingPlan;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabean.
     */
    public Show() {
        performances = new HashSet();
    }

    /**
     * Konstruktor - tworzy nowy obiekt przedstawienia o podanej nazwie.
     * @param name Nazwa przedstawienia.
     */
    public Show(String name) {
        performances = new HashSet();
        this.name = name;
    }

    /**
     * Zwraca identyfikator tego przedstawienia.
     * @return Identyfikator przedstawienia.
     */
    public long getId() {
        return id;
    }

    /**
     * Ustawia identyfikator tego przedsatwienia.
     * @param id Identyfikator przedstawienia.
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * Zwraca nazw tego przedstawienia.
     * @return Nazwa przedstawienia.
     */
    public String getName() {
        return name;
    }

    /**
     * Ustawia nazw tego przedstawienia.
     * @param name Nazwa przedstawienia.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Zwraca plan miejsc dla tego przedstawienia.
     * @return Plan miejsc dla tego przedstawienia.
     */
    public SeatingPlan getSeatingPlan() {
        return seatingPlan;
    }

    /**
     * Ustawia plan miejsc dla tego przedstawienia.
     * @param seatingPlan Plan miejsc dla tego przedstawienia.
     */
    public void setSeatingPlan(SeatingPlan seatingPlan) {
        this.seatingPlan = seatingPlan;
    }

    /**
     * Zwraca miejsca dla wszystkich spektakli tego przedstawienia.
     * @return Miejsca dla wszystkich spektakli tego przedstawienia.
     */
    public Set getPerformances() {
        return performances;
    }

    /**
     * Ustawia spektakle dla tego przedstawienia.
     * @param performances Spektakle dla tego przedstawienia.
     */
    public void setPerformances(Set performances) {
        this.performances = performances;
    }

    /**
     * Dodaje przekazany spektakl do tego przedstawienia.
     * @param performance Spektakl jaki naley doda do przedstawienia.
     */
    public void addPerformance(Performance performance) {
        performance.setShow(this);
        performances.add(performances);
    }

    /**
     * Usuwan przekazany spektakl z tego przedstawienia.
     * @param performance Spektakl jaki naley usun.
     */
    public void removePerformance(Performance performance) {
        performances.remove(performance);
    }

}
