package org.springframework.prospring.ticket.domain;

/**
 * Reprezentuje plan miejsc dla przedstawienia.
 */
public class SeatingPlan {

    // identyfikator planu miejsc.
    private long id;

    // nazwa planu miejsc.
    private String name;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabean.
     */
    public SeatingPlan() {
    }

    /**
     * Konstruktor - tworzy nowy obiekt planu miejsc o podanej nazwie.
     * @param name Nazwa planu miejsc.
     */
    public SeatingPlan(String name) {
        this.name = name;
    }

    /**
     * Zwraca identyfikator planu miejsc.
     * @return Identyfikator planu miejsc.
     */
    public long getId() {
        return id;
    }

    /**
     * Ustawia identyfikator planu miejsc.
     * @param id Identyfikator planu miejsc.
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * Zwraca nazw planu miejsc.
     * @return Nazwa planu miejsc.
     */
    public String getName() {
        return name;
    }

    /**
     * Ustawia nazw planu miejsc.
     * @param name Nazwa planu miejsc.
     */
    public void setName(String name) {
        this.name = name;
    }

}
