package org.springframework.prospring.ticket.domain;

import java.util.*;

/**
 * Reprezentuje zakup.
 */
public class Purchase {

    // identyfikator zakupu.
    private long id;

    // kod uwierzytelniajcy patnoci dla tego zakupu.
    private String paymentAuthorizationCode;

    // data zakupu.
    private Date purchaseDate;

    // nazwa klienta.
    private String customerName;

    // zaszyfrowany numer karty kredytowej.
    private String encryptedCardNumber;

    // adres poczty elektronicznej klienta.
    private String email;

    // adres do rozlicze dla tego zakupu.
    private Address billingAddress;

    // adres wysyki dla tego zakupu.
    private Address deliveryAddress;

    // zarejestrowany uytkownik ktry dokona zakupu.
    private RegisteredUser registeredUser;

    // okrela czy zamwione bilety zostay/zostan pobrane przez uytkownika
    private boolean userCollected;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabean.
     */
    public Purchase() {
    }

    /**
     * Konstruktor - tworzy nowy zakup.
     * @param paymentAuthorizationCode Kod uwierzytelniajcy.
     * @param purchaseDate Data zakupu.
     * @param customerName Nazwa klienta.
     * @param encryptedCardNumber Zaszyfrowany numer karty kredytowej.
     * @param email Adres poczty elektronicznej klienta.
     * @param billingAddress Adres do rozlicze dla tego zakupu.
     * @param deliveryAddress Adres wysyki dla tego zakupu.
     */
    public Purchase(
        String paymentAuthorizationCode,
        Date purchaseDate,
        String customerName,
        String encryptedCardNumber,
        String email,
        Address billingAddress,
        Address deliveryAddress) {

        this.paymentAuthorizationCode = paymentAuthorizationCode;
        this.purchaseDate = purchaseDate;
        this.customerName = customerName;
        this.encryptedCardNumber = encryptedCardNumber;
        this.email = email;
        this.billingAddress = billingAddress;
        this.deliveryAddress = deliveryAddress;
    }

    /**
     * Zwraca identyfikator zakupu.
     * @return Identyfikator zakupu.
     */
    public long getId() {
        return id;
    }

    /**
     * Ustawia identyfikator zakupu.
     * @param id Identyfikator zakupu.
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * Zwraca kod uwierzytelniajcy dla tego zakupu.
     * @return Kod uwierzytelniajcy dla tego zakupu.
     */
    public String getPaymentAuthorizationCode() {
        return paymentAuthorizationCode;
    }

    /**
     * Ustawia kod uwierzytelniajcy dla tego zakupu.
     * @param paymentAuthorizationCode Kod uwierzytelniajcy dla tego zakupu.
     */
    public void setPaymentAuthorizationCode(String paymentAuthorizationCode) {
        this.paymentAuthorizationCode = paymentAuthorizationCode;
    }

    /**
     * Zwraca dat zoenia zakupu.
     * @return Data zoenia zakupu.
     */
    public Date getPurchaseDate() {
        return purchaseDate;
    }

    /**
     * Ustawia dat zoenia zakupu.
     * @param purchaseDate Data zoenia zakupu.
     */
    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    /**
     * Zwraca adres poczty elektronicznej klienta ktry zoy zamwienie.
     * @return Adres poczty elektronicznej klienta.
     */
    public String getEmail() {
        return email;
    }

    /**
     * Ustawia adres poczty elektronicznej klienta ktry zoy zamwienie.
     * @param email Adres poczty elektronicznej klienta.
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * Zwraca adres do rozlicze dla tego zamwienia.
     * @return Adres do rozlicze dla tego zamwienia.
     */
    public Address getBillingAddress() {
        return billingAddress;
    }

    /**
     * Ustawia adres do rozlicze dla tego zamwienia.
     * @param billingAddress Adres do rozlicze dla tego zamwienia.
     */
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    /**
     * Zwraca adres wysyki dla tego zamwienia.
     * @return Adres wysyki dla tego zamwienia.
     */
    public Address getDeliveryAddress() {
        return deliveryAddress;
    }

    /**
     * Ustawia adres wysyki dla tego zamwienia.
     * @param deliveryAddress Adres wysyki dla tego zamwienia.
     */
    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    /**
     * Zwraca nazw klienta ktry zoy zamwienie.
     * @return Nazwa klienta ktry zoy zamwienie.
     */
    public String getCustomerName() {
        return customerName;
    }

    /**
     * Ustawia nazw klienta ktry zoy zamwienie.
     * @param customerName Nazwa klienta ktry zoy zamwienie.
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    /**
     * Zwraca zaszyfrowany numer karty kredytowej uytej do rozliczenia zamwienia.
     * @return Zaszyfrowany numer karty kredytowej uytej do rozliczenia zamwienia.
     */
    public String getEncryptedCardNumber() {
        return encryptedCardNumber;
    }

    /**
     * Ustawia zaszyfrowany numer karty kredytowej uytej do rozliczenia zamwienia.
     * @param encryptedCardNumber Zaszyfrowany numer karty kredytowej uytej do rozliczenia zamwienia.
     */
    public void setEncryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
    }

    /**
     * Zwraca zarejestrowanego uytkownika, ktry zoy zamwienie.
     * @return Zarejestrowany uytkownik, ktry zoy zamwienie lub null jeli uytkownik nie jest zarejestrowany.
     */
    public RegisteredUser getRegisteredUser() {
        return registeredUser;
    }

    /**
     * Ustawia zarejestrowanego uytkownika, ktry zoy zamwienie.
     * @param registeredUser Zarejestrowany uytkownik, ktry zoy zamwienie.
     */
    public void setRegisteredUser(RegisteredUser registeredUser) {
        this.registeredUser = registeredUser;
    }

    /**
     * Zwraca warto logiczn okrelajc czy bilety bd/zostay pobrane przez uytkownika.
     * @return True jeli bilety bd/zostay pobrane przez uytkownika.
     */
    public boolean isUserCollected() {
        return userCollected;
    }

    /**
     * Ustawia warto logiczn okrelajc czy bilety bd/zostay pobrane przez uytkownika.
     * @param userCollected Okrela czy bilety bd/zostay pobrane przez uytkownika.
     */
    public void setUserCollected(boolean userCollected) {
        this.userCollected = userCollected;
    }
}
