package org.springframework.prospring.ticket.domain;

import java.util.*;

/**
 * Reprezentuje struktur cen dla konkretnego przedstawienia. Struktura cen przechowuje
 * grupy cenowe, z ktrych kada okrela cen miejsc nalecych do konkretnej kategorii.
 */
public class PriceStructure {

    // identyfikators struktury cen.
    private long id;

    // nazwa struktury cen.
    private String name;

    // grupy cenowe nalece do tej struktury cen.
    private Set priceBands;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabean.
     */
    public PriceStructure() {
        priceBands = new HashSet();
    }

    /**
     * Konstruktor - tworzy now struktur cen o podanej nazwie.
     * @param name Nazwa struktury cen.
     */
    public PriceStructure(String name) {
        priceBands = new HashSet();
        this.name = name;
    }

    /**
     * Zwraca identyfikator struktury cen.
     * @return Identyfikator struktury cen.
     */
    public long getId() {
        return id;
    }

    /**
     * Ustawia identyfikator struktury cen.
     * @param id Identyfikator struktury cen.
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * Zwraca nazw struktury cen.
     * @return Nazwa struktury cen.
     */
    public String getName() {
        return name;
    }

    /**
     * Ustawia nazw struktury cen.
     * @param name Nazwa struktury cen.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Zwraca grupy cenowe nalece do tej struktury cen.
     * @return Grupy cenowe nalece do tej struktury cen.
     */
    public Set getPriceBands() {
        return priceBands;
    }

    /**
     * Ustawia grupy cenowe nalece do tej struktury cen.
     * @param priceBands Grupy cenowe nalece do tej struktury cen.
     */
    public void setPriceBands(Set priceBands) {
        this.priceBands = priceBands;
    }

    /**
     * Dodaje now grup cenow do tej struktury cen.
     * @param priceBand Grupa cenowa ktr naley doda do tej struktury cen.
     */
    public void addPriceBand(PriceBand priceBand) {
        priceBands.add(priceBand);
    }

    /**
     * Usuwa przekazan grup cenow z tej struktury cen.
     * @param priceBand Grupa cenowa jak naley usun ze struktury cen.
     */
    public void removePriceBand(PriceBand priceBand) {
        priceBands.remove(priceBand);
    }

}
