package org.springframework.prospring.ticket.dao.hibernate;

import org.springframework.prospring.ticket.domain.*;

/**
 * Klasa pomocnicza kojarzca ilo dostpnych miejsc ze spektaklem i zakresem cen.
 */
public class AvailabilityDetail {

    // skojarzony zakres cen.
    private PriceBand priceBand;

    // skojarzony spektakl.
    private Performance performance;

    // ilo dostpnych miejsc.
    private int availableSeatCount;

    /**
     * Pusty konstruktor wymagany przez specyfikacj javabeans.
     */
    public AvailabilityDetail() {
    }

    /**
     * Konstruktor - tworzy nowy obiekt AvailabilityDetails o podanych wartociach.
	 * @param priceBand Skojarzony zakres cen.
	 * @param performance Skojarzony spektakl.
	 * @param availableSeatCount Ilo dostpnych miejsc.
	 */
	public AvailabilityDetail(PriceBand priceBand, Performance performance, int availableSeatCount) {
		super();
		this.priceBand = priceBand;
		this.performance = performance;
		this.availableSeatCount = availableSeatCount;
	}

    /**
     * Zwraca ilo dostpnych miejsc dla danej kombinacji zakresu cen i spektaklu.
     * @return Zwraca ilo dostpnych miejsc.
     */
    public int getAvailableSeatCount() {
		return availableSeatCount;
	}

    /**
     * Ustawia ilo dostpnych miejsc dla danej kombinacji zakresu cen i spektaklu.
     * @param availableSeatCount Ilo dostpnych miejsc.
     */
    public void setAvailableSeatCount(int availableSeatCount) {
		this.availableSeatCount = availableSeatCount;
	}

    /**
     * Zwraca spektakl dla danej kombinacji zakresu cen i spektaklu.
     * @return Spektakl dla danej kombinacji zakresu cen i spektaklu.
     */
    public Performance getPerformance() {
		return performance;
	}

    /**
     * Ustawia spektakl dla danej kombinacji zakresu cen i spektaklu.
     * @param performance Spektakl dla danej kombinacji zakresu cen i spektaklu.
     */
    public void setPerformance(Performance performance) {
		this.performance = performance;
	}

    /**
     * Zwraca zakres cen dla danej kombinacji zakresu cen i spektaklu.
     * @return Zakres cen dla danej kombinacji zakresu cen i spektaklu.
     */
    public PriceBand getPriceBand() {
		return priceBand;
	}

    /**
     * Ustawia zakres cen dla danej kombinacji zakresu cen i spektaklu.
     * @param priceBand Zakres cen dla danej kombinacji zakresu cen i spektaklu.
     */
    public void setPriceBand(PriceBand priceBand) {
		this.priceBand = priceBand;
	}

}
