/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.util.StringSplitter;
import org.apache.tapestry.valid.BaseValidator;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class UrlValidator
extends BaseValidator {
    private int _minimumLength;
    private String _minimumLengthMessage;
    private String _invalidUrlFormatMessage;
    private String _disallowedProtocolMessage;
    private Collection _allowedProtocols;
    private String _scriptPath = "/org/apache/tapestry/valid/UrlValidator.script";

    public UrlValidator() {
    }

    private UrlValidator(boolean required) {
        super(required);
    }

    public String toString(IFormComponent field, Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Object toObject(IFormComponent field, String input) throws ValidatorException {
        if (this.checkRequired(field, input)) {
            return null;
        }
        if (this._minimumLength > 0 && input.length() < this._minimumLength) {
            throw new ValidatorException(this.buildMinimumLengthMessage(field), ValidationConstraint.MINIMUM_WIDTH);
        }
        if (!this.isValidUrl(input)) {
            throw new ValidatorException(this.buildInvalidUrlFormatMessage(field), ValidationConstraint.URL_FORMAT);
        }
        if (!this.isAllowedProtocol(input)) {
            throw new ValidatorException(this.buildDisallowedProtocolMessage(field), ValidationConstraint.DISALLOWED_PROTOCOL);
        }
        return input;
    }

    public int getMinimumLength() {
        return this._minimumLength;
    }

    public void setMinimumLength(int minimumLength) {
        this._minimumLength = minimumLength;
    }

    public void renderValidatorContribution(IFormComponent field, IMarkupWriter writer, IRequestCycle cycle) {
        if (!this.isClientScriptingEnabled()) {
            return;
        }
        HashMap<String, String> symbols = new HashMap<String, String>();
        if (this.isRequired()) {
            symbols.put("requiredMessage", this.buildRequiredMessage(field));
        }
        if (this._minimumLength > 0) {
            symbols.put("minimumLengthMessage", this.buildMinimumLengthMessage(field));
        }
        symbols.put("urlFormatMessage", this.buildInvalidUrlFormatMessage(field));
        symbols.put("urlDisallowedProtocolMessage", this.buildDisallowedProtocolMessage(field));
        symbols.put("urlRegexpProtocols", this.buildUrlRegexpProtocols());
        this.processValidatorScript(this._scriptPath, cycle, field, symbols);
    }

    private String buildUrlRegexpProtocols() {
        if (this._allowedProtocols == null) {
            return null;
        }
        String regexp = "/(";
        Iterator iter = this._allowedProtocols.iterator();
        while (iter.hasNext()) {
            String protocol = (String)iter.next();
            regexp = regexp + protocol;
            if (!iter.hasNext()) continue;
            regexp = regexp + "|";
        }
        regexp = regexp + "):///";
        return regexp;
    }

    public String getScriptPath() {
        return this._scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this._scriptPath = scriptPath;
    }

    protected boolean isValidUrl(String url) {
        boolean bIsValid;
        try {
            new URL(url);
            bIsValid = true;
        }
        catch (MalformedURLException mue) {
            bIsValid = false;
        }
        return bIsValid;
    }

    protected boolean isAllowedProtocol(String url) {
        boolean bIsAllowed = false;
        if (this._allowedProtocols != null) {
            URL oUrl;
            try {
                oUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                return false;
            }
            String actualProtocol = oUrl.getProtocol();
            Iterator iter = this._allowedProtocols.iterator();
            while (iter.hasNext()) {
                String protocol = (String)iter.next();
                if (!protocol.equals(actualProtocol)) continue;
                bIsAllowed = true;
                break;
            }
        } else {
            bIsAllowed = true;
        }
        return bIsAllowed;
    }

    public String getInvalidUrlFormatMessage() {
        return this._invalidUrlFormatMessage;
    }

    public String getMinimumLengthMessage() {
        return this._minimumLengthMessage;
    }

    public void setInvalidUrlFormatMessage(String string) {
        this._invalidUrlFormatMessage = string;
    }

    public String getDisallowedProtocolMessage() {
        return this._disallowedProtocolMessage;
    }

    public void setDisallowedProtocolMessage(String string) {
        this._disallowedProtocolMessage = string;
    }

    public void setMinimumLengthMessage(String string) {
        this._minimumLengthMessage = string;
    }

    protected String buildMinimumLengthMessage(IFormComponent field) {
        String pattern = this.getPattern(this._minimumLengthMessage, "field-too-short", field.getPage().getLocale());
        return this.formatString(pattern, Integer.toString(this._minimumLength), field.getDisplayName());
    }

    protected String buildInvalidUrlFormatMessage(IFormComponent field) {
        String pattern = this.getPattern(this._invalidUrlFormatMessage, "invalid-url-format", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName());
    }

    protected String buildDisallowedProtocolMessage(IFormComponent field) {
        if (this._allowedProtocols == null) {
            return null;
        }
        String pattern = this.getPattern(this._disallowedProtocolMessage, "disallowed-protocol", field.getPage().getLocale());
        String allowedProtocols = "";
        Iterator iter = this._allowedProtocols.iterator();
        while (iter.hasNext()) {
            String protocol = (String)iter.next();
            if (!allowedProtocols.equals("")) {
                allowedProtocols = iter.hasNext() ? allowedProtocols + ", " : allowedProtocols + " or ";
            }
            allowedProtocols = allowedProtocols + protocol;
        }
        return this.formatString(pattern, allowedProtocols);
    }

    protected String getPattern(String override, String key, Locale locale) {
        String string;
        if (override != null) {
            return override;
        }
        try {
            ResourceBundle strings = ResourceBundle.getBundle("net.sf.cendil.tapestry.valid.ValidationStrings", locale);
            string = strings.getString(key);
        }
        catch (Exception exc) {
            ResourceBundle strings = ResourceBundle.getBundle("org.apache.tapestry.valid.ValidationStrings", locale);
            string = strings.getString(key);
        }
        return string;
    }

    public void setAllowedProtocols(String protocols) {
        StringSplitter spliter = new StringSplitter(',');
        String[] aProtocols = spliter.splitToArray(protocols);
        this._allowedProtocols = new Vector();
        for (int i = 0; i < aProtocols.length; ++i) {
            this._allowedProtocols.add(aProtocols[i]);
        }
    }
}

