/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.db.sqlmap;

import com.ibatis.common.beans.StaticBeanProbe;
import com.ibatis.common.exception.NestedRuntimeException;
import com.ibatis.common.resources.Resources;
import com.ibatis.db.sqlmap.MappedStatement;
import com.ibatis.db.sqlmap.ParameterMap;
import com.ibatis.db.sqlmap.ParameterMapping;
import com.ibatis.db.sqlmap.ResultMap;
import com.ibatis.db.sqlmap.ResultMapping;
import com.ibatis.db.sqlmap.SqlMap;
import com.ibatis.db.sqlmap.SqlMapException;
import com.ibatis.db.sqlmap.SqlMapJarEntityResolver;
import com.ibatis.db.sqlmap.cache.CacheModel;
import com.ibatis.db.sqlmap.datasource.DataSourceFactory;
import com.ibatis.db.sqlmap.dynamic.BaseFragment;
import com.ibatis.db.sqlmap.dynamic.ConditionalFragment;
import com.ibatis.db.sqlmap.dynamic.DynamicFragment;
import com.ibatis.db.sqlmap.dynamic.DynamicMappedStatement;
import com.ibatis.db.sqlmap.dynamic.IsEmptyFragment;
import com.ibatis.db.sqlmap.dynamic.IsEqualFragment;
import com.ibatis.db.sqlmap.dynamic.IsGreaterEqualFragment;
import com.ibatis.db.sqlmap.dynamic.IsGreaterThanFragment;
import com.ibatis.db.sqlmap.dynamic.IsLessEqualFragment;
import com.ibatis.db.sqlmap.dynamic.IsLessThanFragment;
import com.ibatis.db.sqlmap.dynamic.IsNotEmptyFragment;
import com.ibatis.db.sqlmap.dynamic.IsNotEqualFragment;
import com.ibatis.db.sqlmap.dynamic.IsNotNullFragment;
import com.ibatis.db.sqlmap.dynamic.IsNotParameterPresentFragment;
import com.ibatis.db.sqlmap.dynamic.IsNotPropertyAvailableFragment;
import com.ibatis.db.sqlmap.dynamic.IsNullFragment;
import com.ibatis.db.sqlmap.dynamic.IsParameterPresentFragment;
import com.ibatis.db.sqlmap.dynamic.IsPropertyAvailableFragment;
import com.ibatis.db.sqlmap.dynamic.IterateFragment;
import com.ibatis.db.sqlmap.dynamic.PrependedFragment;
import com.ibatis.db.sqlmap.dynamic.StaticFragment;
import com.ibatis.db.sqlmap.typehandler.TypeHandler;
import com.ibatis.db.sqlmap.typehandler.TypeHandlerFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;

public class XmlSqlMapBuilder {
    private static final String LEGACY_CACHE_CLASS_NAME = "com.ibatis.db.sqlmap.cache.memory.MemoryCacheController";
    private static final Map cacheControllerAliases = new HashMap();
    private static final String PARAMETER_TOKEN = "#";
    private static final String DOT = ".";
    private static final String SETTINGS_ELEMENT = "settings";
    private static final String SQL_CONFIG_ELEMENT = "sql-map-config";
    private static final String DATASOURCE_ELEMENT = "datasource";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String SQL_MAP_ELEMENT = "sql-map";
    private static final String RESULT_MAP_ELEMENT = "result-map";
    private static final String PARAMETER_MAP_ELEMENT = "parameter-map";
    private static final String MAPPED_STATEMENT_ELEMENT = "mapped-statement";
    private static final String CACHE_MODEL_ELEMENT = "cache-model";
    private static final String DYNAMIC_MAPPED_STATEMENT_ELEMENT = "dynamic-mapped-statement";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String FLUSH_INTERVAL_ELEMENT = "flush-interval";
    private static final String FLUSH_ON_EXECUTE_ELEMENT = "flush-on-execute";
    private static final String CACHE_PROPERTY = "cache-property";
    private static Properties properties;
    private static boolean validationEnabled;

    public static boolean isValidationEnabled() {
        return validationEnabled;
    }

    public static void setValidationEnabled(boolean bl) {
        validationEnabled = bl;
    }

    public static SqlMap buildSqlMap(File file) {
        SqlMap sqlMap;
        block7: {
            sqlMap = new SqlMap();
            properties = null;
            XmlSqlMapBuilder.addDefaultLegacyCache(sqlMap, "STRONG");
            XmlSqlMapBuilder.addDefaultLegacyCache(sqlMap, "SOFT");
            XmlSqlMapBuilder.addDefaultLegacyCache(sqlMap, "WEAK");
            try {
                if (file != null) {
                    if (file.isFile()) {
                        XmlSqlMapBuilder.parseSqlMapRoot(sqlMap, new FileReader(file), file.getAbsolutePath(), false);
                        break block7;
                    }
                    if (file.isDirectory()) {
                        File[] fileArray = file.listFiles();
                        int n = 0;
                        while (n < fileArray.length) {
                            if (fileArray[n].getName().endsWith(".xml")) {
                                XmlSqlMapBuilder.parseSqlMapRoot(sqlMap, new FileReader(fileArray[n]), fileArray[n].getAbsolutePath(), false);
                            }
                            ++n;
                        }
                        break block7;
                    }
                    throw new SqlMapException("Unkown error with input file/directory passed to XmlSqlMapBuilder.buildSqlMap().");
                }
                throw new SqlMapException("Input file/directory passed to XmlSqlMapBuilder.buildSqlMap() was NULL.");
            }
            catch (Exception exception) {
                throw new SqlMapException("Error in XmlSqlMapBuilder.buildSqlMap(). \n\nCause: \n\n" + exception, exception);
            }
        }
        XmlSqlMapBuilder.registerCacheMappings(sqlMap);
        return sqlMap;
    }

    public static SqlMap buildSqlMap(Reader reader) {
        return XmlSqlMapBuilder.buildSqlMap(reader, null, false);
    }

    public static SqlMap buildSqlMap(Reader reader, Properties properties) {
        return XmlSqlMapBuilder.buildSqlMap(reader, properties, false);
    }

    public static synchronized SqlMap buildSqlMap(Reader reader, Properties properties, boolean bl) {
        XmlSqlMapBuilder.properties = properties;
        try {
            SqlMap sqlMap = new SqlMap();
            XmlSqlMapBuilder.addDefaultLegacyCache(sqlMap, "STRONG");
            XmlSqlMapBuilder.addDefaultLegacyCache(sqlMap, "SOFT");
            XmlSqlMapBuilder.addDefaultLegacyCache(sqlMap, "WEAK");
            XmlSqlMapBuilder.parseSqlMapRoot(sqlMap, reader, "[Reader passed to buildSqlMap()]", bl);
            XmlSqlMapBuilder.registerCacheMappings(sqlMap);
            return sqlMap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SqlMapException("Error while building SqlMap.  \n\nCause: \n\n" + exception, exception);
        }
    }

    public static void parseSqlMapRoot(SqlMap sqlMap, Reader reader, String string, boolean bl) throws IOException, JDOMException {
        SAXBuilder sAXBuilder = new SAXBuilder();
        sAXBuilder.setEntityResolver((EntityResolver)new SqlMapJarEntityResolver());
        sAXBuilder.setValidation(validationEnabled);
        Document document = sAXBuilder.build(reader);
        Element element = document.getRootElement();
        String string2 = element.getName();
        if (SQL_MAP_ELEMENT.equals(string2)) {
            XmlSqlMapBuilder.includeSqlMap(sqlMap, element, string);
        } else if (SQL_CONFIG_ELEMENT.equals(string2)) {
            XmlSqlMapBuilder.parseSqlMapConfig(sqlMap, element, string, bl);
        } else {
            throw new IOException("The root tag of the SqlMap XML document must be 'sql-map' or 'sql-map-config'.");
        }
    }

    private static void registerCacheMappings(SqlMap sqlMap) {
        Iterator iterator = sqlMap.getCaches();
        while (iterator.hasNext()) {
            CacheModel cacheModel = (CacheModel)iterator.next();
            Iterator iterator2 = cacheModel.getFlushTriggerStatements();
            while (iterator2.hasNext()) {
                try {
                    String string = (String)iterator2.next();
                    MappedStatement mappedStatement = sqlMap.getMappedStatement(string);
                    mappedStatement.addExecuteListener(cacheModel);
                }
                catch (SqlMapException sqlMapException) {
                    throw new SqlMapException("Error registering cache '" + cacheModel.getName() + "' in '" + cacheModel.getResourceName() + "'. Cause: " + sqlMapException.toString(), (Throwable)((Object)sqlMapException));
                }
            }
        }
    }

    private static void parseSqlMapConfig(SqlMap sqlMap, Element element, String string, boolean bl) throws IOException, JDOMException {
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            String string2;
            Element element2 = (Element)list.get(n);
            if (SQL_MAP_ELEMENT.equals(element2.getName())) {
                string2 = XmlSqlMapBuilder.getAttributeValue(element2, "resource", true);
                XmlSqlMapBuilder.includeSqlMap(sqlMap, string2, bl);
            } else if (PROPERTIES_ELEMENT.equals(element2.getName())) {
                string2 = XmlSqlMapBuilder.getAttributeValue(element2, "resource", true);
                properties = Resources.getResourceAsProperties((String)string2);
            } else if (SETTINGS_ELEMENT.equals(element2.getName())) {
                XmlSqlMapBuilder.parseSettingsElement(sqlMap, element2);
            } else if (DATASOURCE_ELEMENT.equals(element2.getName())) {
                if (!bl) {
                    XmlSqlMapBuilder.parseDataSource(sqlMap, element2, string);
                }
            } else {
                throw new SqlMapException("Uknown element '" + element2.getName() + "' in " + string);
            }
            ++n;
        }
    }

    private static void parseSettingsElement(SqlMap sqlMap, Element element) {
        String string;
        int n = XmlSqlMapBuilder.getAttributeValueAsInt(element, "maxExecute", false);
        if (n > 0) {
            sqlMap.setMaxExecute(n);
        }
        if ((n = XmlSqlMapBuilder.getAttributeValueAsInt(element, "maxExecutePerConnection", false)) > 0) {
            sqlMap.setMaxExecutePerConnection(n);
        }
        if ((n = XmlSqlMapBuilder.getAttributeValueAsInt(element, "maxTransactions", false)) > 0) {
            sqlMap.setMaxTransactions(n);
        }
        if ((n = XmlSqlMapBuilder.getAttributeValueAsInt(element, "statementCacheSize", false)) > 0) {
            sqlMap.setStatementCacheSize(n);
        }
        if ((string = XmlSqlMapBuilder.getAttributeValue(element, "userTransactionJndiName", false)) != null && string.length() > 0) {
            sqlMap.setUserTransactionJndiName(string);
        }
        sqlMap.setUseGlobalTransaction("true".equals(XmlSqlMapBuilder.getAttributeValue(element, "useGlobalTransactions", false)));
        String string2 = XmlSqlMapBuilder.getAttributeValue(element, "useBeansMetaClasses", false);
        if (string2 != null) {
            StaticBeanProbe.setUseMetaClasses((boolean)"true".equals(string2));
        } else {
            StaticBeanProbe.setUseMetaClasses((boolean)false);
        }
        String string3 = XmlSqlMapBuilder.getAttributeValue(element, "useFullyQualifiedStatementNames", false);
        if (string3 != null) {
            sqlMap.setUseFullyQualifiedStatementNames("true".equals(string3));
        } else {
            sqlMap.setUseFullyQualifiedStatementNames(false);
        }
        String string4 = XmlSqlMapBuilder.getAttributeValue(element, "cacheModelsEnabled", false);
        if (string4 != null) {
            sqlMap.setCacheModelsEnabled("true".equals(string4));
        } else {
            sqlMap.setCacheModelsEnabled(true);
        }
        String string5 = XmlSqlMapBuilder.getAttributeValue(element, "startTransactionBeforeConnection", false);
        if (string5 != null) {
            sqlMap.setStartTransactionBeforeConnection("true".equals(string5));
        } else {
            sqlMap.setStartTransactionBeforeConnection(true);
        }
        String string6 = XmlSqlMapBuilder.getAttributeValue(element, "driverHintsEnabled", false);
        if (string6 != null) {
            sqlMap.setDriverHintsEnabled("true".equals(string6));
        } else {
            sqlMap.setDriverHintsEnabled(false);
        }
    }

    private static void parseDataSource(SqlMap sqlMap, Element element, String string) {
        Object object;
        Object object2;
        Element element2;
        String string2 = XmlSqlMapBuilder.getAttributeValue(element, "name", true);
        String string3 = XmlSqlMapBuilder.getAttributeValue(element, "factory-class", true);
        Properties properties = new Properties();
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            element2 = (Element)list.get(n);
            if (!PROPERTY_ELEMENT.equals(element2.getName())) {
                throw new SqlMapException("Uknown element '" + element2.getName() + "' in " + string);
            }
            object2 = XmlSqlMapBuilder.getAttributeValue(element2, "name", true);
            object = XmlSqlMapBuilder.getAttributeValue(element2, "value", true);
            properties.setProperty((String)object2, (String)object);
            ++n;
        }
        try {
            element2 = Class.forName(string3);
            object2 = (DataSourceFactory)element2.newInstance();
            object2.initialize(properties);
            object = object2.getDataSource();
            sqlMap.addDataSource(string2, (DataSource)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SqlMapException("Invalid DataSourceFactory class. Cause: " + classNotFoundException, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new SqlMapException("Could not instantiate DataSourceFactory. Cause: " + instantiationException, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SqlMapException("Could not access constructor for DataSourceFactory class. Cause: " + illegalAccessException, illegalAccessException);
        }
        boolean bl = "true".equals(XmlSqlMapBuilder.getAttributeValue(element, "default", false));
        if (bl) {
            if (sqlMap.getCurrentDataSource() == null) {
                sqlMap.setCurrentDataSourceName(string2);
            } else {
                throw new SqlMapException("Error.  There can be only one default Data Source for a SQL Map.");
            }
        }
    }

    private static void includeSqlMap(SqlMap sqlMap, String string, boolean bl) throws IOException, JDOMException {
        XmlSqlMapBuilder.parseSqlMapRoot(sqlMap, new InputStreamReader(Resources.getResourceAsStream((String)string)), string, bl);
    }

    private static void includeSqlMap(SqlMap sqlMap, Element element, String string) {
        String string2 = XmlSqlMapBuilder.getAttributeValue(element, "name", true);
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            Object object;
            Element element2 = (Element)list.get(n);
            if (PARAMETER_MAP_ELEMENT.equals(element2.getName())) {
                object = XmlSqlMapBuilder.buildParameterMap(element2, string2, string);
                sqlMap.addParameterMap((ParameterMap)object);
            } else if (RESULT_MAP_ELEMENT.equals(element2.getName())) {
                object = XmlSqlMapBuilder.buildResultMap(sqlMap, element2, string2, string);
                sqlMap.addResultMap((ResultMap)object);
            } else if (CACHE_MODEL_ELEMENT.equals(element2.getName())) {
                if (sqlMap.isCacheModelsEnabled()) {
                    object = XmlSqlMapBuilder.buildCache(element2, string);
                    sqlMap.addCache((CacheModel)object);
                }
            } else if (DYNAMIC_MAPPED_STATEMENT_ELEMENT.equals(element2.getName())) {
                object = XmlSqlMapBuilder.buildDynamicMappedStatement(element2, sqlMap, string2, string);
                if (sqlMap.isUseFullyQualifiedStatementNames()) {
                    ((MappedStatement)object).setName(string2 + DOT + ((MappedStatement)object).getName());
                }
                sqlMap.addMappedStatement((MappedStatement)object);
            } else if (MAPPED_STATEMENT_ELEMENT.equals(element2.getName())) {
                object = XmlSqlMapBuilder.buildMappedStatement(element2, sqlMap, string2, string);
                if (sqlMap.isUseFullyQualifiedStatementNames()) {
                    ((MappedStatement)object).setName(string2 + DOT + ((MappedStatement)object).getName());
                }
                sqlMap.addMappedStatement((MappedStatement)object);
            } else {
                throw new SqlMapException("Uknown element '" + element2.getName() + "' in " + string);
            }
            ++n;
        }
    }

    private static void addDefaultLegacyCache(SqlMap sqlMap, String string) {
        Properties properties = new Properties();
        properties.setProperty("reference-type", string);
        CacheModel cacheModel = new CacheModel();
        cacheModel.setName(string);
        cacheModel.setControllerClassName(LEGACY_CACHE_CLASS_NAME);
        cacheModel.configureController(properties);
        sqlMap.addCache(cacheModel);
    }

    private static CacheModel buildCache(Element element, String string) {
        String string2;
        String string3 = XmlSqlMapBuilder.getAttributeValue(element, "name", true);
        String string4 = XmlSqlMapBuilder.getAttributeValue(element, "implementation", false);
        String string5 = XmlSqlMapBuilder.getAttributeValue(element, "reference-type", false);
        if (string4 == null && string5 == null) {
            throw new SqlMapException("Error building the cache-model named '" + string3 + "' in resource '" + string + "'.  Cause: Either an implementation (preferred) or a reference-type (legacy) attribute must be specified.");
        }
        Properties properties = new Properties();
        if (string4 == null) {
            string4 = LEGACY_CACHE_CLASS_NAME;
        }
        if (string5 != null) {
            ((Hashtable)properties).put("reference-type", string5);
        }
        if ((string2 = (String)cacheControllerAliases.get(string4)) != null) {
            string4 = string2;
        }
        CacheModel cacheModel = new CacheModel();
        cacheModel.setName(string3);
        cacheModel.setResourceName(string);
        cacheModel.setControllerClassName(string4);
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            Element element2 = (Element)list.get(n);
            if (FLUSH_INTERVAL_ELEMENT.equals(element2.getName())) {
                long l = 0L;
                try {
                    String string6 = XmlSqlMapBuilder.getAttributeValue(element2, "milliseconds", false);
                    String string7 = XmlSqlMapBuilder.getAttributeValue(element2, "seconds", false);
                    String string8 = XmlSqlMapBuilder.getAttributeValue(element2, "minutes", false);
                    String string9 = XmlSqlMapBuilder.getAttributeValue(element2, "hours", false);
                    if (string6 != null) {
                        l += (long)Integer.parseInt(string6);
                    }
                    if (string7 != null) {
                        l += (long)(Integer.parseInt(string7) * 1000);
                    }
                    if (string8 != null) {
                        l += (long)(Integer.parseInt(string8) * 60 * 1000);
                    }
                    if (string9 != null) {
                        l += (long)(Integer.parseInt(string9) * 60 * 60 * 1000);
                    }
                    if (l < 1L) {
                        throw new NestedRuntimeException("A flush interval must specify one or more of milliseconds, seconds, minutes or hours.");
                    }
                    cacheModel.setFlushInterval(l);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SqlMapException("Error building cache '" + cacheModel.getName() + "' in '" + string + "'.  Flush interval milliseconds must be a valid long integer value.  Cause: " + numberFormatException, numberFormatException);
                }
            } else if (FLUSH_ON_EXECUTE_ELEMENT.equals(element2.getName())) {
                cacheModel.addFlushTriggerStatement(XmlSqlMapBuilder.getAttributeValue(element2, "statement", true));
            } else if (CACHE_PROPERTY.equals(element2.getName())) {
                properties.setProperty(XmlSqlMapBuilder.getAttributeValue(element2, "name", true), XmlSqlMapBuilder.getAttributeValue(element2, "value", true));
            } else {
                throw new SqlMapException("Uknown element '" + element2.getName() + "' in " + string);
            }
            ++n;
        }
        cacheModel.configureController(properties);
        return cacheModel;
    }

    private static ParameterMap buildParameterMap(Element element, String string, String string2) {
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.setName(XmlSqlMapBuilder.getAttributeValue(element, "name", true));
        List list = element.getChildren();
        int n = 0;
        while (n < list.size()) {
            ParameterMapping parameterMapping;
            Element element2 = (Element)list.get(n);
            if (PROPERTY_ELEMENT.equals(element2.getName())) {
                String string3 = XmlSqlMapBuilder.getAttributeValue(element2, "name", true);
                String string4 = XmlSqlMapBuilder.getAttributeValue(element2, "type", false);
                String string5 = XmlSqlMapBuilder.getAttributeValue(element2, "null", false);
                String string6 = XmlSqlMapBuilder.getAttributeValue(element2, "out-param", false);
                parameterMapping = new ParameterMapping();
                parameterMapping.setResourceName(string2);
                parameterMapping.setPropertyName(string3);
                if (string4 != null) {
                    parameterMapping.setType(string4);
                }
                if (string5 != null) {
                    parameterMapping.setNullValue(string5);
                }
                if (string6 != null) {
                    parameterMapping.setOutputParameter("true".equals(string6));
                } else {
                    parameterMapping.setOutputParameter(false);
                }
            } else {
                throw new SqlMapException("Uknown element '" + element2.getName() + "' in " + string2);
            }
            parameterMap.addParameterMapping(parameterMapping);
            ++n;
        }
        parameterMap.setName(string + DOT + parameterMap.getName());
        return parameterMap;
    }

    private static ResultMap buildResultMap(SqlMap sqlMap, Element element, String string, String string2) {
        Object object;
        Object object2;
        ResultMap resultMap = new ResultMap();
        resultMap.setName(XmlSqlMapBuilder.getAttributeValue(element, "name", true));
        resultMap.setClassName(XmlSqlMapBuilder.getAttributeValue(element, "class", true));
        String string3 = XmlSqlMapBuilder.getAttributeValue(element, "extends", false);
        if (string3 != null && !"".equals(string3)) {
            try {
                object2 = null;
                object2 = string3.indexOf(DOT) > -1 ? sqlMap.getResultMap(string3) : sqlMap.getResultMap(string + DOT + string3);
                Iterator iterator = ((ResultMap)object2).getMappedPropertyNames();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    resultMap.addResultMapping(((ResultMap)object2).getResultMapping((String)object));
                }
            }
            catch (Exception exception) {
                throw new SqlMapException("Error building SQL Map.  There was a problem with 'extends' in map named " + resultMap.getName() + ".  Cause: " + exception);
            }
        }
        object2 = element.getChildren();
        int n = 0;
        while (n < object2.size()) {
            ResultMapping resultMapping;
            object = (Element)object2.get(n);
            if (PROPERTY_ELEMENT.equals(object.getName())) {
                String string4;
                String string5;
                String string6;
                String string7;
                String string8 = XmlSqlMapBuilder.getAttributeValue(object, "name", true);
                String string9 = XmlSqlMapBuilder.getAttributeValue(object, "column", false);
                resultMapping = new ResultMapping();
                resultMapping.setPropertyName(string8);
                resultMapping.setColumnName(string9);
                resultMapping.setResourceName(string2);
                String string10 = XmlSqlMapBuilder.getAttributeValue(object, "columnIndex", false);
                if (string10 != null && string10.length() > 0) {
                    resultMapping.setColumnIndex(new Integer(string10));
                }
                if ((string7 = XmlSqlMapBuilder.getAttributeValue(object, MAPPED_STATEMENT_ELEMENT, false)) != null && string7.length() > 0) {
                    resultMapping.setStatementName(string7);
                }
                if ((string6 = XmlSqlMapBuilder.getAttributeValue(object, "lazy-load", false)) != null && string6.length() > 0) {
                    resultMapping.setLazyLoad("true".equals(string6));
                } else {
                    resultMapping.setLazyLoad(true);
                }
                String string11 = XmlSqlMapBuilder.getAttributeValue(object, "type", false);
                if (string11 != null && string11.length() > 0) {
                    resultMapping.setType(string11);
                }
                if ((string5 = XmlSqlMapBuilder.getAttributeValue(object, "null", false)) != null) {
                    resultMapping.setNullValue(string5);
                }
                if ((string4 = XmlSqlMapBuilder.getAttributeValue(object, "javaType", false)) != null && string4.length() > 0) {
                    try {
                        Class<?> clazz = Class.forName(string4);
                        TypeHandler typeHandler = TypeHandlerFactory.getTypeHandler(clazz);
                        resultMapping.setPropertyType(clazz);
                        resultMapping.setTypeHandler(typeHandler);
                    }
                    catch (Exception exception) {
                        throw new SqlMapException("Uknown class \n" + exception + "\n" + object.getName() + "' in " + string2, exception);
                    }
                }
            } else {
                throw new SqlMapException("Uknown element '" + object.getName() + "' in " + string2);
            }
            resultMap.addResultMapping(resultMapping);
            ++n;
        }
        resultMap.setName(string + DOT + resultMap.getName());
        return resultMap;
    }

    private static DynamicMappedStatement buildDynamicMappedStatement(Element element, SqlMap sqlMap, String string, String string2) {
        String string3;
        String string4;
        DynamicMappedStatement dynamicMappedStatement = new DynamicMappedStatement();
        dynamicMappedStatement.setResourceName(string2);
        dynamicMappedStatement.setName(XmlSqlMapBuilder.getAttributeValue(element, "name", true));
        dynamicMappedStatement.setParameterClass(XmlSqlMapBuilder.getAttributeValue(element, "parameter-class", false));
        dynamicMappedStatement.setResultClass(XmlSqlMapBuilder.getAttributeValue(element, "result-class", false));
        dynamicMappedStatement.setResultMapName(XmlSqlMapBuilder.getAttributeValue(element, RESULT_MAP_ELEMENT, false));
        dynamicMappedStatement.setStoredProcedure("true".equals(XmlSqlMapBuilder.getAttributeValue(element, "is-stored-procedure", false)));
        if (sqlMap.isCacheModelsEnabled() && (string4 = XmlSqlMapBuilder.getAttributeValue(element, CACHE_MODEL_ELEMENT, false)) != null) {
            try {
                dynamicMappedStatement.setCache(sqlMap.getCache(string4));
            }
            catch (SqlMapException sqlMapException) {
                throw new SqlMapException("Error building mapped statement '" + dynamicMappedStatement.getName() + "' in '" + string2 + "'.  Cause: " + sqlMapException.toString(), (Throwable)((Object)sqlMapException));
            }
        }
        dynamicMappedStatement.setInline(true);
        dynamicMappedStatement.addAllChildFragment(XmlSqlMapBuilder.buildFragmentList(element));
        dynamicMappedStatement.setSqlMap(sqlMap);
        if (dynamicMappedStatement.isInline()) {
            dynamicMappedStatement.setParameterMapName(string + DOT + dynamicMappedStatement.getName() + "-inline");
        }
        if ((string4 = dynamicMappedStatement.getParameterMapName()) != null && string4.indexOf(DOT) < 0) {
            dynamicMappedStatement.setParameterMapName(string + DOT + dynamicMappedStatement.getParameterMapName());
        }
        if ((string3 = dynamicMappedStatement.getResultMapName()) != null && string3.indexOf(DOT) < 0) {
            dynamicMappedStatement.setResultMapName(string + DOT + dynamicMappedStatement.getResultMapName());
        }
        return dynamicMappedStatement;
    }

    private static List buildFragmentList(Element element) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = element.getContent().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object e = iterator.next();
            if (e instanceof Element) {
                DynamicFragment dynamicFragment;
                object2 = (Element)e;
                if ("dynamic".equals(object2.getName())) {
                    object = new DynamicFragment();
                    ((PrependedFragment)object).setPrepend(XmlSqlMapBuilder.getAttributeValue((Element)object2, "prepend", false));
                    ((DynamicFragment)object).addAllChildFragment(XmlSqlMapBuilder.buildFragmentList((Element)object2));
                    arrayList.add(object);
                    continue;
                }
                object = null;
                if ("isEqual".equals(object2.getName())) {
                    object = new IsEqualFragment();
                } else if ("isNotEqual".equals(object2.getName())) {
                    object = new IsNotEqualFragment();
                } else if ("isParameterPresent".equals(object2.getName())) {
                    object = new IsParameterPresentFragment();
                } else if ("isNotParameterPresent".equals(object2.getName())) {
                    object = new IsNotParameterPresentFragment();
                } else if ("isEmpty".equals(object2.getName())) {
                    object = new IsEmptyFragment();
                } else if ("isNotEmpty".equals(object2.getName())) {
                    object = new IsNotEmptyFragment();
                } else if ("isNull".equals(object2.getName())) {
                    object = new IsNullFragment();
                } else if ("isNotNull".equals(object2.getName())) {
                    object = new IsNotNullFragment();
                } else if ("isPropertyAvailable".equals(object2.getName())) {
                    object = new IsPropertyAvailableFragment();
                } else if ("isNotPropertyAvailable".equals(object2.getName())) {
                    object = new IsNotPropertyAvailableFragment();
                } else if ("isGreaterThan".equals(object2.getName())) {
                    object = new IsGreaterThanFragment();
                } else if ("isGreaterEqual".equals(object2.getName())) {
                    object = new IsGreaterEqualFragment();
                } else if ("isLessThan".equals(object2.getName())) {
                    object = new IsLessThanFragment();
                } else if ("isLessEqual".equals(object2.getName())) {
                    object = new IsLessEqualFragment();
                } else if ("iterate".equals(object2.getName())) {
                    object = new IterateFragment();
                } else {
                    throw new SqlMapException("Unknown conditional tag: " + element.getName());
                }
                if (object instanceof ConditionalFragment) {
                    dynamicFragment = (ConditionalFragment)object;
                    dynamicFragment.setPrepend(XmlSqlMapBuilder.getAttributeValue((Element)object2, "prepend", false));
                    ((ConditionalFragment)dynamicFragment).setPropertyName(XmlSqlMapBuilder.getAttributeValue((Element)object2, PROPERTY_ELEMENT, false));
                    ((ConditionalFragment)dynamicFragment).setCompareValue(XmlSqlMapBuilder.getAttributeValue((Element)object2, "compareValue", false));
                    ((ConditionalFragment)dynamicFragment).setComparePropertyName(XmlSqlMapBuilder.getAttributeValue((Element)object2, "compareProperty", false));
                    dynamicFragment.setSqlFragment(object2.getText());
                    dynamicFragment.addAllChildFragment(XmlSqlMapBuilder.buildFragmentList((Element)object2));
                } else if (object instanceof IterateFragment) {
                    dynamicFragment = (IterateFragment)object;
                    dynamicFragment.setPrepend(XmlSqlMapBuilder.getAttributeValue((Element)object2, "prepend", false));
                    ((IterateFragment)dynamicFragment).setPropertyName(XmlSqlMapBuilder.getAttributeValue((Element)object2, PROPERTY_ELEMENT, false));
                    ((IterateFragment)dynamicFragment).setClose(XmlSqlMapBuilder.getAttributeValue((Element)object2, "close", false));
                    ((IterateFragment)dynamicFragment).setOpen(XmlSqlMapBuilder.getAttributeValue((Element)object2, "open", false));
                    ((IterateFragment)dynamicFragment).setConjunction(XmlSqlMapBuilder.getAttributeValue((Element)object2, "conjunction", false));
                    dynamicFragment.setSqlFragment(object2.getText());
                    dynamicFragment.addAllChildFragment(XmlSqlMapBuilder.buildFragmentList((Element)object2));
                }
                arrayList.add(object);
                continue;
            }
            if (e instanceof CDATA) {
                object2 = new StaticFragment();
                object = ((CDATA)e).getText();
                object = XmlSqlMapBuilder.parsePropertyTokens((String)object, properties);
                ((BaseFragment)object2).setSqlFragment((String)object);
                arrayList.add(object2);
                continue;
            }
            if (!(e instanceof Text)) continue;
            object2 = new StaticFragment();
            object = ((Text)e).getText();
            object = XmlSqlMapBuilder.parsePropertyTokens((String)object, properties);
            ((BaseFragment)object2).setSqlFragment((String)object);
            arrayList.add(object2);
        }
        return arrayList;
    }

    private static MappedStatement buildMappedStatement(Element element, SqlMap sqlMap, String string, String string2) {
        String string3;
        String string4;
        MappedStatement mappedStatement = new MappedStatement();
        mappedStatement.setResourceName(string2);
        mappedStatement.setName(XmlSqlMapBuilder.getAttributeValue(element, "name", true));
        mappedStatement.setParameterMapName(XmlSqlMapBuilder.getAttributeValue(element, PARAMETER_MAP_ELEMENT, false));
        mappedStatement.setResultMapName(XmlSqlMapBuilder.getAttributeValue(element, RESULT_MAP_ELEMENT, false));
        mappedStatement.setStoredProcedure("true".equals(XmlSqlMapBuilder.getAttributeValue(element, "is-stored-procedure", false)));
        if (sqlMap.isCacheModelsEnabled() && (string4 = XmlSqlMapBuilder.getAttributeValue(element, CACHE_MODEL_ELEMENT, false)) != null) {
            try {
                mappedStatement.setCache(sqlMap.getCache(string4));
            }
            catch (SqlMapException sqlMapException) {
                throw new SqlMapException("Error building mapped statement '" + mappedStatement.getName() + "' in '" + string2 + "'.  Cause: " + sqlMapException.toString(), (Throwable)((Object)sqlMapException));
            }
        }
        mappedStatement.setParameterClass(XmlSqlMapBuilder.getAttributeValue(element, "parameter-class", false));
        mappedStatement.setResultClass(XmlSqlMapBuilder.getAttributeValue(element, "result-class", false));
        string4 = XmlSqlMapBuilder.getAttributeValue(element, "inline-parameters", false);
        if (string4 == null && mappedStatement.getParameterMapName() == null) {
            mappedStatement.setInline(true);
        } else {
            mappedStatement.setInline("true".equals(string4));
        }
        String string5 = element.getText();
        if (string5 == null || string5.trim().length() <= 0) {
            throw new SqlMapException("A mapped statement element requires body content in " + string2);
        }
        String string6 = string5.trim();
        string6 = XmlSqlMapBuilder.parsePropertyTokens(string6, properties);
        mappedStatement.setSql(string6);
        mappedStatement.setSqlMap(sqlMap);
        if (mappedStatement.isInline()) {
            mappedStatement.setParameterMapName(string + DOT + mappedStatement.getName() + "-inline");
            XmlSqlMapBuilder.processInlineParameterMap(mappedStatement, string2);
        }
        if ((string6 = mappedStatement.getParameterMapName()) != null && string6.indexOf(DOT) < 0) {
            mappedStatement.setParameterMapName(string + DOT + mappedStatement.getParameterMapName());
        }
        if ((string3 = mappedStatement.getResultMapName()) != null && string3.indexOf(DOT) < 0) {
            mappedStatement.setResultMapName(string + DOT + mappedStatement.getResultMapName());
        }
        return mappedStatement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processInlineParameterMap(MappedStatement mappedStatement, String string) {
        ParameterMap parameterMap = new ParameterMap();
        parameterMap.setName(mappedStatement.getParameterMapName());
        StringTokenizer stringTokenizer = new StringTokenizer(mappedStatement.getSql(null), PARAMETER_TOKEN, true);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (PARAMETER_TOKEN.equals(string3)) {
                if (PARAMETER_TOKEN.equals(string2)) {
                    stringBuffer.append(PARAMETER_TOKEN);
                    string2 = null;
                } else {
                    Object object;
                    if (string2.indexOf(58) > -1) {
                        Object object2;
                        Object object3;
                        String string4;
                        String string5;
                        object = new StringTokenizer(string2, ":", true);
                        int n = ((StringTokenizer)object).countTokens();
                        if (n == 3) {
                            string5 = ((StringTokenizer)object).nextToken();
                            ((StringTokenizer)object).nextToken();
                            string4 = ((StringTokenizer)object).nextToken();
                            object3 = new ParameterMapping();
                            ((ParameterMapping)object3).setResourceName(string);
                            ((ParameterMapping)object3).setPropertyName(string5);
                            ((ParameterMapping)object3).setType(string4);
                            parameterMap.addParameterMapping((ParameterMapping)object3);
                        } else if (n >= 5) {
                            string5 = ((StringTokenizer)object).nextToken();
                            ((StringTokenizer)object).nextToken();
                            string4 = ((StringTokenizer)object).nextToken();
                            ((StringTokenizer)object).nextToken();
                            object3 = ((StringTokenizer)object).nextToken();
                            object2 = null;
                            boolean bl = false;
                            if ("OUT!".equals(object3)) {
                                bl = true;
                            } else {
                                object2 = object3;
                                while (((StringTokenizer)object).hasMoreTokens()) {
                                    object2 = (String)object2 + ((StringTokenizer)object).nextToken();
                                }
                            }
                            ParameterMapping parameterMapping = new ParameterMapping();
                            parameterMapping.setResourceName(string);
                            parameterMapping.setPropertyName(string5);
                            parameterMapping.setType(string4);
                            parameterMapping.setNullValue((String)object2);
                            parameterMapping.setOutputParameter(bl);
                            parameterMap.addParameterMapping(parameterMapping);
                        } else {
                            if (n < 7) throw new SqlMapException("Incorrect inline parameter map format: " + string2);
                            string5 = ((StringTokenizer)object).nextToken();
                            ((StringTokenizer)object).nextToken();
                            string4 = ((StringTokenizer)object).nextToken();
                            ((StringTokenizer)object).nextToken();
                            object3 = ((StringTokenizer)object).nextToken();
                            ((StringTokenizer)object).nextToken();
                            object2 = ((StringTokenizer)object).nextToken();
                            while (((StringTokenizer)object).hasMoreTokens()) {
                                object2 = (String)object2 + ((StringTokenizer)object).nextToken();
                            }
                            ParameterMapping parameterMapping = new ParameterMapping();
                            parameterMapping.setResourceName(string);
                            parameterMapping.setPropertyName(string5);
                            parameterMapping.setType(string4);
                            parameterMapping.setNullValue((String)object2);
                            parameterMapping.setOutputParameter("OUT!".equals(object3));
                            parameterMap.addParameterMapping(parameterMapping);
                        }
                    } else {
                        object = new ParameterMapping();
                        ((ParameterMapping)object).setResourceName(string);
                        ((ParameterMapping)object).setPropertyName(string2);
                        parameterMap.addParameterMapping((ParameterMapping)object);
                    }
                    stringBuffer.append("?");
                    string2 = stringTokenizer.nextToken();
                    if (!PARAMETER_TOKEN.equals(string2)) {
                        throw new SqlMapException("Unterminated inline parameter in mapped statement (" + mappedStatement.getName() + ").");
                    }
                    string2 = null;
                }
            } else if (!PARAMETER_TOKEN.equals(string2)) {
                stringBuffer.append(string2);
            }
            string3 = string2;
        }
        mappedStatement.setSql(stringBuffer.toString());
        mappedStatement.getSqlMap().addParameterMap(parameterMap);
    }

    private static int getAttributeValueAsInt(Element element, String string, boolean bl) {
        String string2 = XmlSqlMapBuilder.getAttributeValue(element, string, bl);
        try {
            if (string2 != null && !"".equals(string2)) {
                return Integer.parseInt(string2);
            }
            return -1;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SqlMapException("Error configuring SqlMap.  The attribute named '" + string + "' must be an integer (was " + string2 + ").  Cause: " + numberFormatException, numberFormatException);
        }
    }

    private static String getAttributeValue(Element element, String string, boolean bl) {
        String string2 = null;
        Attribute attribute = element.getAttribute(string);
        if (attribute != null) {
            string2 = attribute.getValue();
        }
        string2 = XmlSqlMapBuilder.parsePropertyTokens(string2, properties);
        if (bl && string2 == null) {
            throw new SqlMapException("Error while building SQL Map.  A '" + element.getName() + "' element requires a '" + string + "' attribute.");
        }
        return string2;
    }

    private static String parsePropertyTokens(String string, Properties properties) {
        String string2 = string;
        if (string2 != null && properties != null) {
            int n = string2.indexOf("${");
            int n2 = string2.indexOf("}");
            while (n > -1 && n2 > n) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n2 + "}".length());
                String string5 = string2.substring(n + "${".length(), n2);
                String string6 = properties.getProperty(string5);
                string2 = string6 == null ? string3 + string4 : string3 + string6 + string4;
                n = string2.indexOf("${");
                n2 = string2.indexOf("}");
            }
        }
        return string2;
    }

    static {
        validationEnabled = true;
        cacheControllerAliases.put("MEMORY", LEGACY_CACHE_CLASS_NAME);
        cacheControllerAliases.put("LRU", "com.ibatis.db.sqlmap.cache.lru.LruCacheController");
        cacheControllerAliases.put("FIFO", "com.ibatis.db.sqlmap.cache.fifo.FifoCacheController");
        cacheControllerAliases.put("OSCACHE", "com.ibatis.db.sqlmap.cache.oscache.OSCacheController");
    }
}

