/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.easymock.internal.Range;
import org.easymock.internal.Result;

public class ResultList {
    private int callCount;
    private LinkedList ranges = new LinkedList();
    private List results = new ArrayList();

    void add(Result result, Range range) {
        Range lastRange;
        if (!this.ranges.isEmpty() && !(lastRange = (Range)this.ranges.getLast()).hasFixedCount()) {
            throw new IllegalStateException("last method called on mock already has a non-fixed count set.");
        }
        this.ranges.add(range);
        this.results.add(result);
    }

    Result next() {
        int currentPosition = 0;
        int i = 0;
        while (i < this.ranges.size()) {
            Range interval = (Range)this.ranges.get(i);
            if (interval.hasOpenCount()) {
                ++this.callCount;
                return this.getResult(i);
            }
            if ((currentPosition += interval.getMaximum()) > this.callCount) {
                ++this.callCount;
                return this.getResult(i);
            }
            ++i;
        }
        return null;
    }

    private Result getResult(int i) {
        return (Result)this.results.get(i);
    }

    boolean hasValidCallCount() {
        return this.getMainInterval().contains(this.getCallCount());
    }

    String getMessage() {
        return this.getMessage(this.getCallCount());
    }

    String getMessage(int count) {
        return this.getMainInterval().expectedAndActual(count);
    }

    private Range getMainInterval() {
        int min = 0;
        int max = 0;
        int i = 0;
        while (i < this.ranges.size()) {
            Range interval = (Range)this.ranges.get(i);
            min += interval.getMinimum();
            max = interval.hasOpenCount() || max == Integer.MAX_VALUE ? Integer.MAX_VALUE : (max += interval.getMaximum());
            ++i;
        }
        return new Range(min, max);
    }

    public int getCallCount() {
        return this.callCount;
    }
}

